/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.api;

import io.split.client.dtos.Partition;
import io.split.client.dtos.Prerequisites;
import io.split.engine.experiments.ParsedCondition;
import io.split.engine.experiments.ParsedSplit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SplitView {
    public String name;
    public String trafficType;
    public boolean killed;
    public List<String> treatments;
    public long changeNumber;
    public Map<String, String> configs;
    public List<String> sets;
    public String defaultTreatment;
    public boolean impressionsDisabled;
    public List<Prerequisites> prerequisites;

    public static SplitView fromParsedSplit(ParsedSplit parsedSplit) {
        SplitView splitView = new SplitView();
        splitView.name = parsedSplit.feature();
        splitView.trafficType = parsedSplit.trafficTypeName();
        splitView.killed = parsedSplit.killed();
        splitView.changeNumber = parsedSplit.changeNumber();
        splitView.sets = parsedSplit.flagSets() != null ? new ArrayList<String>(parsedSplit.flagSets()) : new ArrayList();
        splitView.defaultTreatment = parsedSplit.defaultTreatment();
        HashSet<String> treatments = new HashSet<String>();
        for (ParsedCondition condition : parsedSplit.parsedConditions()) {
            for (Partition partition : condition.partitions()) {
                treatments.add(partition.treatment);
            }
        }
        treatments.add(parsedSplit.defaultTreatment());
        splitView.treatments = new ArrayList<String>(treatments);
        splitView.configs = parsedSplit.configurations() == null ? Collections.emptyMap() : parsedSplit.configurations();
        splitView.impressionsDisabled = parsedSplit.impressionsDisabled();
        splitView.prerequisites = parsedSplit.prerequisitesMatcher() != null ? parsedSplit.prerequisitesMatcher().getPrerequisites() : new ArrayList();
        return splitView;
    }
}

