/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.impressions;

import io.split.client.SplitClientConfig;
import io.split.client.dtos.DecoratedImpression;
import io.split.client.dtos.KeyImpression;
import io.split.client.dtos.TestImpressions;
import io.split.client.impressions.Impression;
import io.split.client.impressions.ImpressionCounter;
import io.split.client.impressions.ImpressionListener;
import io.split.client.impressions.ImpressionsManager;
import io.split.client.impressions.ImpressionsResult;
import io.split.client.impressions.ImpressionsSender;
import io.split.client.impressions.ImpressionsStorageConsumer;
import io.split.client.impressions.ImpressionsStorageProducer;
import io.split.client.impressions.strategy.ProcessImpressionNone;
import io.split.client.impressions.strategy.ProcessImpressionStrategy;
import io.split.client.utils.SplitExecutorFactory;
import io.split.telemetry.domain.enums.ImpressionsDataTypeEnum;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import java.io.Closeable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.base.Preconditions;

public class ImpressionsManagerImpl
implements ImpressionsManager,
Closeable {
    private static final Logger _log = LoggerFactory.getLogger(ImpressionsManagerImpl.class);
    private static final long BULK_INITIAL_DELAY_SECONDS = 10L;
    private static final long COUNT_INITIAL_DELAY_SECONDS = 100L;
    private static final long COUNT_REFRESH_RATE_SECONDS = 1800L;
    private final SplitClientConfig _config;
    private final ImpressionsStorageProducer _impressionsStorageProducer;
    private final ImpressionsStorageConsumer _impressionsStorageConsumer;
    private final ScheduledExecutorService _scheduler;
    private final ImpressionsSender _impressionsSender;
    private final ImpressionListener _listener;
    private final ImpressionsManager.Mode _impressionsMode;
    private TelemetryRuntimeProducer _telemetryRuntimeProducer;
    private ImpressionCounter _counter;
    private ProcessImpressionStrategy _processImpressionStrategy;
    private ProcessImpressionNone _processImpressionNone;
    private final int _impressionsRefreshRate;

    public static ImpressionsManagerImpl instance(SplitClientConfig config, TelemetryRuntimeProducer telemetryRuntimeProducer, ImpressionsStorageConsumer impressionsStorageConsumer, ImpressionsStorageProducer impressionsStorageProducer, ImpressionsSender impressionsSender, ProcessImpressionNone processImpressionNone, ProcessImpressionStrategy processImpressionStrategy, ImpressionCounter counter, ImpressionListener listener) throws URISyntaxException {
        return new ImpressionsManagerImpl(config, impressionsSender, telemetryRuntimeProducer, impressionsStorageConsumer, impressionsStorageProducer, processImpressionNone, processImpressionStrategy, counter, listener);
    }

    public static ImpressionsManagerImpl instanceForTest(SplitClientConfig config, ImpressionsSender impressionsSender, TelemetryRuntimeProducer telemetryRuntimeProducer, ImpressionsStorageConsumer impressionsStorageConsumer, ImpressionsStorageProducer impressionsStorageProducer, ProcessImpressionNone processImpressionNone, ProcessImpressionStrategy processImpressionStrategy, ImpressionCounter counter, ImpressionListener listener) {
        return new ImpressionsManagerImpl(config, impressionsSender, telemetryRuntimeProducer, impressionsStorageConsumer, impressionsStorageProducer, processImpressionNone, processImpressionStrategy, counter, listener);
    }

    private ImpressionsManagerImpl(SplitClientConfig config, ImpressionsSender impressionsSender, TelemetryRuntimeProducer telemetryRuntimeProducer, ImpressionsStorageConsumer impressionsStorageConsumer, ImpressionsStorageProducer impressionsStorageProducer, ProcessImpressionNone processImpressionNone, ProcessImpressionStrategy processImpressionStrategy, ImpressionCounter impressionCounter, ImpressionListener impressionListener) {
        this._config = Preconditions.checkNotNull(config);
        this._impressionsMode = Preconditions.checkNotNull(config.impressionsMode());
        this._impressionsStorageConsumer = Preconditions.checkNotNull(impressionsStorageConsumer);
        this._impressionsStorageProducer = Preconditions.checkNotNull(impressionsStorageProducer);
        this._telemetryRuntimeProducer = Preconditions.checkNotNull(telemetryRuntimeProducer);
        this._processImpressionNone = Preconditions.checkNotNull(processImpressionNone);
        this._processImpressionStrategy = Preconditions.checkNotNull(processImpressionStrategy);
        this._impressionsSender = impressionsSender;
        this._counter = impressionCounter;
        this._scheduler = SplitExecutorFactory.buildScheduledExecutorService(config.getThreadFactory(), "Split-ImpressionsManager-%d", 2);
        this._listener = impressionListener;
        this._impressionsRefreshRate = config.impressionsRefreshRate();
    }

    @Override
    public void start() {
        switch (this._impressionsMode) {
            case OPTIMIZED: {
                this._scheduler.scheduleAtFixedRate(this::sendImpressionCounters, 100L, 1800L, TimeUnit.SECONDS);
                this._scheduler.scheduleAtFixedRate(this::sendImpressions, 10L, this._impressionsRefreshRate, TimeUnit.SECONDS);
                break;
            }
            case DEBUG: {
                this._scheduler.scheduleAtFixedRate(this::sendImpressions, 10L, this._impressionsRefreshRate, TimeUnit.SECONDS);
                this._scheduler.scheduleAtFixedRate(this::sendImpressionCounters, 100L, 1800L, TimeUnit.SECONDS);
                break;
            }
            case NONE: {
                this._scheduler.scheduleAtFixedRate(this::sendImpressionCounters, 100L, 1800L, TimeUnit.SECONDS);
            }
        }
    }

    @Override
    public void track(List<DecoratedImpression> decoratedImpressions) {
        if (null == decoratedImpressions) {
            return;
        }
        ArrayList<Impression> impressionsForLogs = new ArrayList<Impression>();
        ArrayList<Impression> impressionsToListener = new ArrayList<Impression>();
        for (int i = 0; i < decoratedImpressions.size(); ++i) {
            ImpressionsResult impressionsResult = !decoratedImpressions.get(i).disabled() ? this._processImpressionStrategy.process(Stream.of(decoratedImpressions.get(i).impression()).collect(Collectors.toList())) : this._processImpressionNone.process(Stream.of(decoratedImpressions.get(i).impression()).collect(Collectors.toList()));
            if (!Objects.isNull(impressionsResult.getImpressionsToQueue())) {
                impressionsForLogs.addAll(impressionsResult.getImpressionsToQueue());
            }
            if (Objects.isNull(impressionsResult.getImpressionsToListener())) continue;
            impressionsToListener.addAll(impressionsResult.getImpressionsToListener());
        }
        int totalImpressions = impressionsForLogs.size();
        long queued = this._impressionsStorageProducer.put(impressionsForLogs.stream().map(KeyImpression::fromImpression).collect(Collectors.toList()));
        if (queued < (long)totalImpressions) {
            this._telemetryRuntimeProducer.recordImpressionStats(ImpressionsDataTypeEnum.IMPRESSIONS_DROPPED, (long)totalImpressions - queued);
        }
        this._telemetryRuntimeProducer.recordImpressionStats(ImpressionsDataTypeEnum.IMPRESSIONS_QUEUED, queued);
        if (this._listener != null) {
            impressionsToListener.forEach(imp -> this._listener.log((Impression)imp));
        }
    }

    @Override
    public void close() {
        try {
            if (this._listener != null) {
                this._listener.close();
                _log.info("Successful shutdown of ImpressionListener");
            }
            this._scheduler.shutdown();
            this.sendImpressions();
            if (this._counter != null) {
                this.sendImpressionCounters();
            }
        }
        catch (Exception e) {
            _log.warn("Unable to close ImpressionsManager properly", (Throwable)e);
        }
    }

    @VisibleForTesting
    void sendImpressions() {
        if (this._impressionsStorageConsumer.isFull()) {
            _log.warn("Split SDK impressions queue is full. Impressions may have been dropped. Consider increasing capacity.");
        }
        long start = System.currentTimeMillis();
        List<KeyImpression> impressions = this._impressionsStorageConsumer.pop();
        if (impressions.isEmpty()) {
            return;
        }
        this._impressionsSender.postImpressionsBulk(TestImpressions.fromKeyImpressions(impressions));
        if (this._config.debugEnabled()) {
            _log.info(String.format("Posting %d Split impressions took %d millis", impressions.size(), System.currentTimeMillis() - start));
        }
    }

    @VisibleForTesting
    void sendImpressionCounters() {
        if (!this._counter.isEmpty()) {
            this._impressionsSender.postCounters(this._counter.popAll());
        }
    }

    @VisibleForTesting
    ImpressionCounter getCounter() {
        return this._counter;
    }
}

