/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.impressions;

import io.split.client.dtos.UniqueKeys;
import io.split.client.impressions.UniqueKeysTracker;
import io.split.client.impressions.filters.BloomFilterImp;
import io.split.client.impressions.filters.FilterAdapter;
import io.split.client.impressions.filters.FilterAdapterImpl;
import io.split.client.utils.SplitExecutorFactory;
import io.split.telemetry.synchronizer.TelemetrySynchronizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.collect.Lists;

public class UniqueKeysTrackerImp
implements UniqueKeysTracker {
    private static final Logger _log = LoggerFactory.getLogger(UniqueKeysTrackerImp.class);
    private static final double MARGIN_ERROR = 0.01;
    private static final int MAX_UNIQUE_KEYS_POST_SIZE = 5000;
    private static final int MAX_AMOUNT_OF_KEYS = 10000000;
    private final AtomicInteger trackerKeysSize = new AtomicInteger(0);
    private FilterAdapter filterAdapter;
    private final TelemetrySynchronizer _telemetrySynchronizer;
    private final ScheduledExecutorService _uniqueKeysSyncScheduledExecutorService;
    private final ScheduledExecutorService _cleanFilterScheduledExecutorService;
    private final ConcurrentHashMap<String, HashSet<String>> uniqueKeysTracker;
    private final int _uniqueKeysRefreshRate;
    private final int _filterRefreshRate;
    private final AtomicBoolean sendGuard = new AtomicBoolean(false);
    private static final Logger _logger = LoggerFactory.getLogger(UniqueKeysTrackerImp.class);

    public UniqueKeysTrackerImp(TelemetrySynchronizer telemetrySynchronizer, int uniqueKeysRefreshRate, int filterRefreshRate, ThreadFactory threadFactory) {
        BloomFilterImp bloomFilter = new BloomFilterImp(10000000, 0.01);
        this.filterAdapter = new FilterAdapterImpl(bloomFilter);
        this.uniqueKeysTracker = new ConcurrentHashMap();
        this._telemetrySynchronizer = telemetrySynchronizer;
        this._uniqueKeysRefreshRate = uniqueKeysRefreshRate;
        this._filterRefreshRate = filterRefreshRate;
        this._uniqueKeysSyncScheduledExecutorService = SplitExecutorFactory.buildSingleThreadScheduledExecutor(threadFactory, "UniqueKeys-sync-%d");
        this._cleanFilterScheduledExecutorService = SplitExecutorFactory.buildSingleThreadScheduledExecutor(threadFactory, "Filter-%d");
    }

    @Override
    public boolean track(String featureFlagName, String key) {
        if (!this.filterAdapter.add(featureFlagName, key)) {
            _logger.debug("The feature flag " + featureFlagName + " and key " + key + " exist in the UniqueKeysTracker");
            return false;
        }
        this.uniqueKeysTracker.compute(featureFlagName, (feature, current) -> {
            HashSet<String> keysByFeature = Optional.ofNullable(current).orElse(new HashSet());
            keysByFeature.add(key);
            this.trackerKeysSize.incrementAndGet();
            return keysByFeature;
        });
        _logger.debug("The feature flag " + featureFlagName + " and key " + key + " was added");
        if (this.trackerKeysSize.intValue() >= 5000) {
            _logger.warn("The UniqueKeysTracker size reached the maximum limit");
            try {
                this.sendUniqueKeys();
            }
            catch (Exception e) {
                _log.error("Error sending unique keys.", (Throwable)e);
            }
        }
        return true;
    }

    @Override
    public void start() {
        this.scheduleWithFixedDelay(this._uniqueKeysSyncScheduledExecutorService, this._uniqueKeysRefreshRate, new ExecuteSendUniqueKeys());
        this.scheduleWithFixedDelay(this._cleanFilterScheduledExecutorService, this._filterRefreshRate, new ExecuteCleanFilter());
    }

    private void scheduleWithFixedDelay(ScheduledExecutorService scheduledExecutorService, int refreshRate, ExecuteUniqueKeysAction executeUniqueKeysAction) {
        scheduledExecutorService.scheduleWithFixedDelay(() -> {
            try {
                executeUniqueKeysAction.execute();
            }
            catch (Exception e) {
                _log.error("Error executing an Unique Key Action.", (Throwable)e);
            }
        }, refreshRate, refreshRate, TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        try {
            this.sendUniqueKeys();
        }
        catch (Exception e) {
            _log.error("Error sending unique keys.");
        }
        this._uniqueKeysSyncScheduledExecutorService.shutdown();
        this._cleanFilterScheduledExecutorService.shutdown();
    }

    public HashMap<String, HashSet<String>> popAll() {
        HashMap<String, HashSet<String>> toReturn = new HashMap<String, HashSet<String>>();
        for (String key : this.uniqueKeysTracker.keySet()) {
            HashSet<String> value = this.uniqueKeysTracker.remove(key);
            toReturn.put(key, value);
        }
        this.trackerKeysSize.set(0);
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUniqueKeys() {
        if (!this.sendGuard.compareAndSet(false, true)) {
            _log.debug("SendUniqueKeys already running");
            return;
        }
        try {
            if (this.uniqueKeysTracker.isEmpty()) {
                _log.debug("The Unique Keys Tracker is empty");
                return;
            }
            HashMap<String, HashSet<String>> uniqueKeysHashMap = this.popAll();
            List<UniqueKeys.UniqueKey> uniqueKeysFromPopAll = new ArrayList<UniqueKeys.UniqueKey>();
            for (Map.Entry<String, HashSet<String>> entry : uniqueKeysHashMap.entrySet()) {
                UniqueKeys.UniqueKey uniqueKey = new UniqueKeys.UniqueKey(entry.getKey(), new ArrayList<String>((Collection)entry.getValue()));
                uniqueKeysFromPopAll.add(uniqueKey);
            }
            uniqueKeysFromPopAll = this.capChunksToMaxSize(uniqueKeysFromPopAll);
            for (List list : this.getChunks(uniqueKeysFromPopAll)) {
                this._telemetrySynchronizer.synchronizeUniqueKeys(new UniqueKeys(list));
            }
        }
        finally {
            this.sendGuard.set(false);
        }
    }

    private List<UniqueKeys.UniqueKey> capChunksToMaxSize(List<UniqueKeys.UniqueKey> uniqueKeys) {
        ArrayList<UniqueKeys.UniqueKey> finalChunk = new ArrayList<UniqueKeys.UniqueKey>();
        for (UniqueKeys.UniqueKey uniqueKey : uniqueKeys) {
            if (uniqueKey.keysDto.size() > 5000) {
                for (List<String> subChunk : Lists.partition(uniqueKey.keysDto, 5000)) {
                    finalChunk.add(new UniqueKeys.UniqueKey(uniqueKey.featureName, subChunk));
                }
                continue;
            }
            finalChunk.add(uniqueKey);
        }
        return finalChunk;
    }

    private List<List<UniqueKeys.UniqueKey>> getChunks(List<UniqueKeys.UniqueKey> uniqueKeys) {
        ArrayList<List<UniqueKeys.UniqueKey>> chunks = new ArrayList<List<UniqueKeys.UniqueKey>>();
        ArrayList<UniqueKeys.UniqueKey> intermediateChunk = new ArrayList<UniqueKeys.UniqueKey>();
        for (UniqueKeys.UniqueKey uniqueKey : uniqueKeys) {
            if (this.getChunkSize(intermediateChunk) + uniqueKey.keysDto.size() > 5000) {
                chunks.add(intermediateChunk);
                intermediateChunk = new ArrayList();
            }
            intermediateChunk.add(uniqueKey);
        }
        if (!intermediateChunk.isEmpty()) {
            chunks.add(intermediateChunk);
        }
        return chunks;
    }

    private int getChunkSize(List<UniqueKeys.UniqueKey> uniqueKeysChunk) {
        int totalSize = 0;
        for (UniqueKeys.UniqueKey uniqueKey : uniqueKeysChunk) {
            totalSize += uniqueKey.keysDto.size();
        }
        return totalSize;
    }

    public AtomicBoolean getSendGuard() {
        return this.sendGuard;
    }

    private class ExecuteSendUniqueKeys
    implements ExecuteUniqueKeysAction {
        private ExecuteSendUniqueKeys() {
        }

        @Override
        public void execute() {
            UniqueKeysTrackerImp.this.sendUniqueKeys();
        }
    }

    private class ExecuteCleanFilter
    implements ExecuteUniqueKeysAction {
        private ExecuteCleanFilter() {
        }

        @Override
        public void execute() {
            UniqueKeysTrackerImp.this.filterAdapter.clear();
        }
    }

    private static interface ExecuteUniqueKeysAction {
        public void execute();
    }
}

