/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.utils;

import io.split.client.dtos.ChangeDto;
import io.split.client.dtos.Condition;
import io.split.client.dtos.ConditionType;
import io.split.client.dtos.KeySelector;
import io.split.client.dtos.Matcher;
import io.split.client.dtos.MatcherCombiner;
import io.split.client.dtos.MatcherGroup;
import io.split.client.dtos.MatcherType;
import io.split.client.dtos.Partition;
import io.split.client.dtos.RuleBasedSegment;
import io.split.client.dtos.SegmentChange;
import io.split.client.dtos.Split;
import io.split.client.dtos.SplitChange;
import io.split.client.dtos.Status;
import io.split.client.dtos.WhitelistMatcherData;
import io.split.client.utils.LocalhostConstants;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import split.com.google.common.base.Preconditions;

public final class LocalhostSanitizer {
    private static final String DEFAULT_RULE = "default rule";

    private LocalhostSanitizer() {
        throw new IllegalStateException("Utility class");
    }

    public static SplitChange sanitization(SplitChange splitChange) {
        LocalhostSanitizer.sanitizeTillAndSince(splitChange);
        splitChange.featureFlags.d = LocalhostSanitizer.sanitizeFeatureFlags(splitChange.featureFlags.d);
        splitChange.ruleBasedSegments.d = LocalhostSanitizer.sanitizeRuleBasedSegments(splitChange.ruleBasedSegments.d);
        return splitChange;
    }

    private static List<RuleBasedSegment> sanitizeRuleBasedSegments(List<RuleBasedSegment> ruleBasedSegments) {
        ArrayList<RuleBasedSegment> ruleBasedSegmentsToRemove = new ArrayList<RuleBasedSegment>();
        if (ruleBasedSegments != null) {
            for (RuleBasedSegment ruleBasedSegment : ruleBasedSegments) {
                if (ruleBasedSegment.name == null) {
                    ruleBasedSegmentsToRemove.add(ruleBasedSegment);
                    continue;
                }
                ruleBasedSegment.trafficTypeName = LocalhostSanitizer.sanitizeIfNullOrEmpty(ruleBasedSegment.trafficTypeName, "user");
                ruleBasedSegment.status = LocalhostSanitizer.sanitizeStatus(ruleBasedSegment.status);
                ruleBasedSegment.changeNumber = LocalhostSanitizer.sanitizeChangeNumber(ruleBasedSegment.changeNumber, 0L);
                ruleBasedSegment.conditions = LocalhostSanitizer.sanitizeConditions((ArrayList)ruleBasedSegment.conditions, false, ruleBasedSegment.trafficTypeName);
                ruleBasedSegment.excluded.segments = LocalhostSanitizer.sanitizeExcluded((ArrayList)ruleBasedSegment.excluded.segments);
                ruleBasedSegment.excluded.keys = LocalhostSanitizer.sanitizeExcluded((ArrayList)ruleBasedSegment.excluded.keys);
            }
            ruleBasedSegments.removeAll(ruleBasedSegmentsToRemove);
        } else {
            ruleBasedSegments = new ArrayList<RuleBasedSegment>();
        }
        return ruleBasedSegments;
    }

    private static List<Split> sanitizeFeatureFlags(List<Split> featureFlags) {
        ArrayList<Split> splitsToRemove = new ArrayList<Split>();
        if (featureFlags != null) {
            for (Split split : featureFlags) {
                if (split.name == null) {
                    splitsToRemove.add(split);
                    continue;
                }
                split.trafficTypeName = LocalhostSanitizer.sanitizeIfNullOrEmpty(split.trafficTypeName, "user");
                split.status = LocalhostSanitizer.sanitizeStatus(split.status);
                split.defaultTreatment = LocalhostSanitizer.sanitizeIfNullOrEmpty(split.defaultTreatment, "control");
                split.changeNumber = LocalhostSanitizer.sanitizeChangeNumber(split.changeNumber, 0L);
                split.trafficAllocation = LocalhostSanitizer.sanitizeTrafficAllocation(split.trafficAllocation);
                split.trafficAllocationSeed = LocalhostSanitizer.sanitizeSeed(split.trafficAllocationSeed);
                split.seed = LocalhostSanitizer.sanitizeSeed(split.seed);
                split.algo = LocalhostSanitizer.sanitizeAlgo(split.algo);
                split.conditions = LocalhostSanitizer.sanitizeConditions((ArrayList)split.conditions, false, split.trafficTypeName);
            }
            featureFlags.removeAll(splitsToRemove);
        } else {
            featureFlags = new ArrayList<Split>();
        }
        return featureFlags;
    }

    private static int sanitizeSeed(Integer seed) {
        SecureRandom random = new SecureRandom();
        if (seed == null || seed == 0) {
            seed = -random.nextInt(10) * 1000;
        }
        return seed;
    }

    private static int sanitizeAlgo(int algo) {
        if (algo != 2) {
            algo = 2;
        }
        return algo;
    }

    private static int sanitizeTrafficAllocation(Integer trafficAllocation) {
        if (trafficAllocation == null || trafficAllocation < 0 || trafficAllocation > LocalhostConstants.SIZE_100) {
            trafficAllocation = LocalhostConstants.SIZE_100;
        }
        return trafficAllocation;
    }

    private static ArrayList<Condition> sanitizeConditions(ArrayList<Condition> conditions, boolean createPartition, String trafficTypeName) {
        if (conditions == null) {
            conditions = new ArrayList();
        }
        Condition condition = new Condition();
        if (!conditions.isEmpty()) {
            condition = conditions.get(conditions.size() - 1);
        }
        if (conditions.isEmpty() || !condition.conditionType.equals((Object)ConditionType.ROLLOUT) || condition.matcherGroup.matchers == null || condition.matcherGroup.matchers.isEmpty() || !condition.matcherGroup.matchers.get((int)0).matcherType.equals((Object)MatcherType.ALL_KEYS)) {
            Condition rolloutCondition = new Condition();
            conditions.add(LocalhostSanitizer.createRolloutCondition(rolloutCondition, trafficTypeName, null, createPartition));
        }
        return conditions;
    }

    private static String sanitizeIfNullOrEmpty(String toBeSanitized, String defaultValue) {
        if (toBeSanitized == null || toBeSanitized.isEmpty()) {
            return defaultValue;
        }
        return toBeSanitized;
    }

    private static long sanitizeChangeNumber(long toBeSanitized, long defaultValue) {
        if (toBeSanitized < 0L) {
            return defaultValue;
        }
        return toBeSanitized;
    }

    private static Status sanitizeStatus(Status toBeSanitized) {
        if (toBeSanitized == null || toBeSanitized != Status.ACTIVE && toBeSanitized != Status.ARCHIVED) {
            return Status.ACTIVE;
        }
        return toBeSanitized;
    }

    private static ArrayList sanitizeExcluded(ArrayList excluded) {
        if (excluded == null) {
            return new ArrayList();
        }
        return excluded;
    }

    private static SplitChange sanitizeTillAndSince(SplitChange splitChange) {
        if (LocalhostSanitizer.checkTillConditions(splitChange.featureFlags)) {
            splitChange.featureFlags.t = LocalhostConstants.DEFAULT_TS;
        }
        if (LocalhostSanitizer.checkSinceConditions(splitChange.featureFlags)) {
            splitChange.featureFlags.s = splitChange.featureFlags.t;
        }
        if (LocalhostSanitizer.checkTillConditions(splitChange.ruleBasedSegments)) {
            splitChange.ruleBasedSegments.t = LocalhostConstants.DEFAULT_TS;
        }
        if (LocalhostSanitizer.checkSinceConditions(splitChange.ruleBasedSegments)) {
            splitChange.ruleBasedSegments.s = splitChange.ruleBasedSegments.t;
        }
        return splitChange;
    }

    private static <T> boolean checkTillConditions(ChangeDto<T> change) {
        return change.t < LocalhostConstants.DEFAULT_TS || change.t == 0L;
    }

    private static <T> boolean checkSinceConditions(ChangeDto<T> change) {
        return change.s < LocalhostConstants.DEFAULT_TS || change.s > change.t;
    }

    public static SegmentChange sanitization(SegmentChange segmentChange) {
        if (segmentChange.name == null || segmentChange.name.isEmpty()) {
            return null;
        }
        if (segmentChange.added == null) {
            segmentChange.added = new ArrayList<String>();
        }
        if (segmentChange.removed == null) {
            segmentChange.removed = new ArrayList<String>();
        }
        List addedToRemoved = segmentChange.added.stream().filter(add -> segmentChange.removed.contains(add)).collect(Collectors.toList());
        segmentChange.removed.removeAll(addedToRemoved);
        if (segmentChange.till < LocalhostConstants.DEFAULT_TS || segmentChange.till == 0L) {
            segmentChange.till = LocalhostConstants.DEFAULT_TS;
        }
        if (segmentChange.since < LocalhostConstants.DEFAULT_TS || segmentChange.since > segmentChange.till) {
            segmentChange.since = segmentChange.till;
        }
        return segmentChange;
    }

    public static Condition createRolloutCondition(Condition condition, String trafficType, String treatment, boolean createPartition) {
        condition.conditionType = ConditionType.ROLLOUT;
        condition.matcherGroup = new MatcherGroup();
        condition.matcherGroup.combiner = MatcherCombiner.AND;
        Matcher matcher = new Matcher();
        KeySelector keySelector = new KeySelector();
        keySelector.trafficType = trafficType;
        matcher.keySelector = keySelector;
        matcher.matcherType = MatcherType.ALL_KEYS;
        matcher.negate = false;
        condition.matcherGroup.matchers = new ArrayList<Matcher>();
        condition.matcherGroup.matchers.add(matcher);
        if (createPartition) {
            condition.partitions = new ArrayList<Partition>();
            Partition partition1 = new Partition();
            Partition partition2 = new Partition();
            partition1.size = LocalhostConstants.SIZE_100;
            partition2.size = LocalhostConstants.SIZE_0;
            if (treatment != null) {
                partition1.treatment = treatment;
            } else {
                partition1.treatment = "off";
                partition2.treatment = "on";
            }
            condition.partitions.add(partition1);
            condition.partitions.add(partition2);
        }
        condition.label = DEFAULT_RULE;
        return condition;
    }

    public static Condition createCondition(Object keyOrKeys, String treatment) {
        Condition condition = new Condition();
        if (keyOrKeys == null) {
            return LocalhostSanitizer.createRolloutCondition(condition, "user", treatment, true);
        }
        if (keyOrKeys instanceof String) {
            ArrayList<String> keys = new ArrayList<String>();
            keys.add((String)keyOrKeys);
            return LocalhostSanitizer.createWhitelistCondition(condition, "user", treatment, keys);
        }
        Preconditions.checkArgument(keyOrKeys instanceof List, "'keys' is not a String nor a List.");
        return LocalhostSanitizer.createWhitelistCondition(condition, "user", treatment, (List)keyOrKeys);
    }

    public static Condition createWhitelistCondition(Condition condition, String trafficType, String treatment, List<String> keys) {
        condition.conditionType = ConditionType.WHITELIST;
        condition.matcherGroup = new MatcherGroup();
        condition.matcherGroup.combiner = MatcherCombiner.AND;
        Matcher matcher = new Matcher();
        KeySelector keySelector = new KeySelector();
        keySelector.trafficType = trafficType;
        matcher.keySelector = keySelector;
        matcher.matcherType = MatcherType.WHITELIST;
        matcher.negate = false;
        matcher.whitelistMatcherData = new WhitelistMatcherData();
        matcher.whitelistMatcherData.whitelist = new ArrayList<String>(keys);
        condition.matcherGroup.matchers = new ArrayList<Matcher>();
        condition.matcherGroup.matchers.add(matcher);
        condition.partitions = new ArrayList<Partition>();
        Partition partition1 = new Partition();
        Partition partition2 = new Partition();
        partition1.size = LocalhostConstants.SIZE_100;
        partition2.size = LocalhostConstants.SIZE_0;
        if (treatment != null) {
            partition1.treatment = treatment;
        } else {
            partition1.treatment = "off";
            partition2.treatment = "on";
        }
        condition.partitions.add(partition1);
        condition.partitions.add(partition2);
        condition.label = DEFAULT_RULE;
        return condition;
    }
}

