/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.common;

import io.split.engine.SDKReadinessGates;
import io.split.engine.common.SyncManager;
import io.split.engine.common.Synchronizer;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;

public class LocalhostSyncManager
implements SyncManager {
    private static final Logger _log = LoggerFactory.getLogger(LocalhostSyncManager.class);
    private final Synchronizer _localhostSynchronizer;
    private final SDKReadinessGates _gates;

    public LocalhostSyncManager(Synchronizer localhostSynchronizer, SDKReadinessGates sdkReadinessGates) {
        this._localhostSynchronizer = Preconditions.checkNotNull(localhostSynchronizer);
        this._gates = sdkReadinessGates;
    }

    @Override
    public void start() {
        if (!this._localhostSynchronizer.syncAll()) {
            _log.error("Could not synchronize feature flag and segment files");
            return;
        }
        this._gates.sdkInternalReady();
        this._localhostSynchronizer.startPeriodicFetching();
    }

    @Override
    public void shutdown() throws IOException {
        this._localhostSynchronizer.stopPeriodicFetching();
    }
}

