/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.matchers;

import io.split.client.exceptions.SemverParseException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Semver {
    private static final String METADATA_DELIMITER = "+";
    private static final String PRERELEASE_DELIMITER = "-";
    private static final String VALUE_DELIMITER = "\\.";
    private static final Logger _log = LoggerFactory.getLogger(Semver.class);
    private Long _major;
    private Long _minor;
    private Long _patch;
    private String[] _preRelease = new String[0];
    private boolean _isStable;
    private String _metadata;
    private String _version;

    public static Semver build(String version) {
        if (version.isEmpty()) {
            return null;
        }
        try {
            return new Semver(version);
        }
        catch (Exception ex) {
            _log.error("An error occurred during the creation of a Semver instance:", (Object)ex.getMessage());
            return null;
        }
    }

    public String version() {
        return this._version;
    }

    public Long major() {
        return this._major;
    }

    public Long minor() {
        return this._minor;
    }

    public Long patch() {
        return this._patch;
    }

    public String[] prerelease() {
        return this._preRelease;
    }

    public String metadata() {
        return this._metadata;
    }

    public boolean isStable() {
        return this._isStable;
    }

    public int compare(Semver toCompare) {
        if (this._version.equals(toCompare.version())) {
            return 0;
        }
        int result = Long.compare(this._major, toCompare.major());
        if (result != 0) {
            return result;
        }
        result = Long.compare(this._minor, toCompare.minor());
        if (result != 0) {
            return result;
        }
        result = Long.compare(this._patch, toCompare.patch());
        if (result != 0) {
            return result;
        }
        if (!this._isStable && toCompare.isStable()) {
            return -1;
        }
        if (this._isStable && !toCompare.isStable()) {
            return 1;
        }
        int minLength = Math.min(this._preRelease.length, toCompare.prerelease().length);
        for (int i = 0; i < minLength; ++i) {
            if (this._preRelease[i].equals(toCompare.prerelease()[i])) continue;
            if (Semver.isNumeric(this._preRelease[i]) && Semver.isNumeric(toCompare._preRelease[i])) {
                return Long.compare(Integer.parseInt(this._preRelease[i]), Long.parseLong(toCompare._preRelease[i]));
            }
            return this.adjustNumber(this._preRelease[i].compareTo(toCompare._preRelease[i]));
        }
        return Integer.compare(this._preRelease.length, toCompare._preRelease.length);
    }

    private int adjustNumber(int number) {
        if (number > 0) {
            return 1;
        }
        if (number < 0) {
            return -1;
        }
        return 0;
    }

    private Semver(String version) throws SemverParseException {
        String vWithoutMetadata = this.setAndRemoveMetadataIfExists(version);
        String vWithoutPreRelease = this.setAndRemovePreReleaseIfExists(vWithoutMetadata);
        this.setMajorMinorAndPatch(vWithoutPreRelease);
        this._version = this.setVersion();
    }

    private String setAndRemoveMetadataIfExists(String version) throws SemverParseException {
        int index = version.indexOf(METADATA_DELIMITER);
        if (index == -1) {
            return version;
        }
        this._metadata = version.substring(index + 1);
        if (this._metadata == null || this._metadata.isEmpty()) {
            throw new SemverParseException("Unable to convert to Semver, incorrect pre release data");
        }
        return version.substring(0, index);
    }

    private String setAndRemovePreReleaseIfExists(String vWithoutMetadata) throws SemverParseException {
        int index = vWithoutMetadata.indexOf(PRERELEASE_DELIMITER);
        if (index == -1) {
            this._isStable = true;
            return vWithoutMetadata;
        }
        String preReleaseData = vWithoutMetadata.substring(index + 1);
        this._preRelease = preReleaseData.split(VALUE_DELIMITER);
        if (this._preRelease == null || Arrays.stream(this._preRelease).allMatch(pr -> pr == null || pr.isEmpty())) {
            throw new SemverParseException("Unable to convert to Semver, incorrect pre release data");
        }
        return vWithoutMetadata.substring(0, index);
    }

    private void setMajorMinorAndPatch(String version) throws SemverParseException {
        String[] vParts = version.split(VALUE_DELIMITER);
        if (vParts.length != 3) {
            throw new SemverParseException("Unable to convert to Semver, incorrect format: " + version);
        }
        this._major = Long.parseLong(vParts[0]);
        this._minor = Long.parseLong(vParts[1]);
        this._patch = Long.parseLong(vParts[2]);
    }

    private String setVersion() {
        String toReturn = this._major + VALUE_DELIMITER + this._minor + VALUE_DELIMITER + this._patch;
        if (this._preRelease != null && this._preRelease.length != 0) {
            for (int i = 0; i < this._preRelease.length; ++i) {
                if (!Semver.isNumeric(this._preRelease[i])) continue;
                this._preRelease[i] = Long.toString(Long.parseLong(this._preRelease[i]));
            }
            toReturn = toReturn + PRERELEASE_DELIMITER + String.join((CharSequence)VALUE_DELIMITER, this._preRelease);
        }
        if (this._metadata != null && !this._metadata.isEmpty()) {
            toReturn = toReturn + METADATA_DELIMITER + this._metadata;
        }
        return toReturn;
    }

    private static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

