/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.sse.dtos;

import io.split.client.utils.Json;
import io.split.engine.segments.SegmentSynchronizationTaskImp;
import io.split.engine.sse.NotificationProcessor;
import io.split.engine.sse.dtos.GenericNotificationData;
import io.split.engine.sse.dtos.IncomingNotification;
import io.split.engine.sse.enums.CompressType;
import io.split.engine.sse.utils.DecompressionUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.zip.DataFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonChangeNotification<Y>
extends IncomingNotification {
    private static final Logger _log = LoggerFactory.getLogger(SegmentSynchronizationTaskImp.class);
    private final long changeNumber;
    private long previousChangeNumber;
    private CompressType compressType;
    private Y definition;
    private Class _definitionClass;

    public CommonChangeNotification(GenericNotificationData genericNotificationData, Class definitionClass) {
        super(genericNotificationData.getType(), genericNotificationData.getChannel());
        this.changeNumber = genericNotificationData.getChangeNumber();
        this._definitionClass = definitionClass;
        if (genericNotificationData.getPreviousChangeNumber() != null) {
            this.previousChangeNumber = genericNotificationData.getPreviousChangeNumber();
        }
        this.compressType = CompressType.from(genericNotificationData.getCompressType());
        if (this.compressType == null || genericNotificationData.getDefinition() == null) {
            return;
        }
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(genericNotificationData.getDefinition());
            switch (this.compressType) {
                case GZIP: {
                    decodedBytes = DecompressionUtil.gZipDecompress(decodedBytes);
                    break;
                }
                case ZLIB: {
                    decodedBytes = DecompressionUtil.zLibDecompress(decodedBytes);
                }
            }
            this.updateDefinition(decodedBytes);
        }
        catch (UnsupportedEncodingException | IllegalArgumentException e) {
            _log.warn("Could not decode base64 data in definition", (Throwable)e);
        }
        catch (DataFormatException d) {
            _log.warn("Could not decompress definition with zlib algorithm", (Throwable)d);
        }
        catch (IOException i) {
            _log.warn("Could not decompress definition with gzip algorithm", (Throwable)i);
        }
    }

    public long getChangeNumber() {
        return this.changeNumber;
    }

    public long getPreviousChangeNumber() {
        return this.previousChangeNumber;
    }

    public CompressType getCompressType() {
        return this.compressType;
    }

    public Y getDefinition() {
        return this.definition;
    }

    @Override
    public void handler(NotificationProcessor notificationProcessor) {
        notificationProcessor.processUpdates(this);
    }

    public String toString() {
        return String.format("Type: %s; Channel: %s; ChangeNumber: %s", new Object[]{this.getType(), this.getChannel(), this.getChangeNumber()});
    }

    private void updateDefinition(byte[] decodedBytes) {
        this.definition = Json.fromJson(new String(decodedBytes, StandardCharsets.UTF_8), this._definitionClass);
    }
}

