/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.sse.workers;

import io.split.client.dtos.RuleBasedSegment;
import io.split.client.dtos.Split;
import io.split.client.interceptors.FlagSetsFilter;
import io.split.client.utils.FeatureFlagProcessor;
import io.split.client.utils.FeatureFlagsToUpdate;
import io.split.client.utils.RuleBasedSegmentProcessor;
import io.split.client.utils.RuleBasedSegmentsToUpdate;
import io.split.engine.common.Synchronizer;
import io.split.engine.experiments.RuleBasedSegmentParser;
import io.split.engine.experiments.SplitParser;
import io.split.engine.sse.dtos.CommonChangeNotification;
import io.split.engine.sse.dtos.IncomingNotification;
import io.split.engine.sse.dtos.SplitKillNotification;
import io.split.engine.sse.workers.FeatureFlagsWorker;
import io.split.engine.sse.workers.Worker;
import io.split.storages.RuleBasedSegmentCache;
import io.split.storages.SplitCacheProducer;
import io.split.telemetry.domain.enums.UpdatesFromSSEEnum;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;

public class FeatureFlagWorkerImp
extends Worker<IncomingNotification>
implements FeatureFlagsWorker {
    private static final Logger _log = LoggerFactory.getLogger(FeatureFlagWorkerImp.class);
    private final Synchronizer _synchronizer;
    private final SplitParser _splitParser;
    private final RuleBasedSegmentParser _ruleBasedSegmentParser;
    private final SplitCacheProducer _splitCacheProducer;
    private final RuleBasedSegmentCache _ruleBasedSegmentCache;
    private final TelemetryRuntimeProducer _telemetryRuntimeProducer;
    private final FlagSetsFilter _flagSetsFilter;

    public FeatureFlagWorkerImp(Synchronizer synchronizer, SplitParser splitParser, RuleBasedSegmentParser ruleBasedSegmentParser, SplitCacheProducer splitCacheProducer, RuleBasedSegmentCache ruleBasedSegmentCache, TelemetryRuntimeProducer telemetryRuntimeProducer, FlagSetsFilter flagSetsFilter) {
        super("Feature flags");
        this._synchronizer = Preconditions.checkNotNull(synchronizer);
        this._splitParser = splitParser;
        this._ruleBasedSegmentParser = ruleBasedSegmentParser;
        this._splitCacheProducer = splitCacheProducer;
        this._telemetryRuntimeProducer = telemetryRuntimeProducer;
        this._flagSetsFilter = flagSetsFilter;
        this._ruleBasedSegmentCache = ruleBasedSegmentCache;
    }

    @Override
    public void kill(SplitKillNotification splitKillNotification) {
        try {
            this._synchronizer.localKillSplit(splitKillNotification);
            _log.debug(String.format("Kill feature flag: %s, changeNumber: %s, defaultTreatment: %s", splitKillNotification.getSplitName(), splitKillNotification.getChangeNumber(), splitKillNotification.getDefaultTreatment()));
        }
        catch (Exception ex) {
            _log.warn(String.format("Exception on FeatureFlagWorker kill: %s", ex.getMessage()));
        }
    }

    @Override
    protected void executeRefresh(IncomingNotification incomingNotification) {
        boolean success;
        long changeNumber = 0L;
        long changeNumberRBS = 0L;
        if (incomingNotification.getType() == IncomingNotification.Type.SPLIT_UPDATE) {
            CommonChangeNotification featureFlagChangeNotification = (CommonChangeNotification)incomingNotification;
            success = this.addOrUpdateFeatureFlag(featureFlagChangeNotification);
            changeNumber = featureFlagChangeNotification.getChangeNumber();
        } else {
            CommonChangeNotification ruleBasedSegmentChangeNotification = (CommonChangeNotification)incomingNotification;
            success = this.addOrUpdateRuleBasedSegment(ruleBasedSegmentChangeNotification);
            changeNumberRBS = ruleBasedSegmentChangeNotification.getChangeNumber();
        }
        if (!success) {
            this._synchronizer.refreshSplits(changeNumber, changeNumberRBS);
        }
    }

    private boolean addOrUpdateRuleBasedSegment(CommonChangeNotification ruleBasedSegmentChangeNotification) {
        if (ruleBasedSegmentChangeNotification.getChangeNumber() <= this._ruleBasedSegmentCache.getChangeNumber()) {
            return true;
        }
        try {
            if (ruleBasedSegmentChangeNotification.getDefinition() != null && ruleBasedSegmentChangeNotification.getPreviousChangeNumber() == this._ruleBasedSegmentCache.getChangeNumber()) {
                RuleBasedSegment ruleBasedSegment = (RuleBasedSegment)ruleBasedSegmentChangeNotification.getDefinition();
                RuleBasedSegmentsToUpdate ruleBasedSegmentsToUpdate = RuleBasedSegmentProcessor.processRuleBasedSegmentChanges(this._ruleBasedSegmentParser, Collections.singletonList(ruleBasedSegment));
                this._ruleBasedSegmentCache.update(ruleBasedSegmentsToUpdate.getToAdd(), ruleBasedSegmentsToUpdate.getToRemove(), ruleBasedSegmentChangeNotification.getChangeNumber());
                Set<String> segments = ruleBasedSegmentsToUpdate.getSegments();
                for (String segmentName : segments) {
                    this._synchronizer.forceRefreshSegment(segmentName);
                }
                return true;
            }
        }
        catch (Exception e) {
            _log.warn("Something went wrong processing a Rule based Segment notification", (Throwable)e);
        }
        return false;
    }

    private boolean addOrUpdateFeatureFlag(CommonChangeNotification featureFlagChangeNotification) {
        if (featureFlagChangeNotification.getChangeNumber() <= this._splitCacheProducer.getChangeNumber()) {
            return true;
        }
        try {
            if (featureFlagChangeNotification.getDefinition() != null && featureFlagChangeNotification.getPreviousChangeNumber() == this._splitCacheProducer.getChangeNumber()) {
                Set<String> ruleBasedSegments;
                Split featureFlag = (Split)featureFlagChangeNotification.getDefinition();
                FeatureFlagsToUpdate featureFlagsToUpdate = FeatureFlagProcessor.processFeatureFlagChanges(this._splitParser, Collections.singletonList(featureFlag), this._flagSetsFilter);
                this._splitCacheProducer.update(featureFlagsToUpdate.getToAdd(), featureFlagsToUpdate.getToRemove(), featureFlagChangeNotification.getChangeNumber());
                Set<String> segments = featureFlagsToUpdate.getSegments();
                for (String segmentName : segments) {
                    this._synchronizer.forceRefreshSegment(segmentName);
                }
                if (featureFlagsToUpdate.getToAdd().stream().count() > 0L && !(ruleBasedSegments = featureFlagsToUpdate.getToAdd().get(0).getRuleBasedSegmentsNames()).isEmpty() && !this._ruleBasedSegmentCache.contains(ruleBasedSegments)) {
                    return false;
                }
                this._telemetryRuntimeProducer.recordUpdatesFromSSE(UpdatesFromSSEEnum.SPLITS);
                return true;
            }
        }
        catch (Exception e) {
            _log.warn("Something went wrong processing a Feature Flag notification", (Throwable)e);
        }
        return false;
    }
}

