/*
 * Decompiled with CFR 0.152.
 */
package io.split.service;

import io.split.client.dtos.SplitHttpResponse;
import io.split.client.utils.Json;
import io.split.service.SplitHttpClient;
import io.split.telemetry.domain.enums.HttpParamsWrapper;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;

public class HttpPostImp {
    private static final Logger _logger = LoggerFactory.getLogger(HttpPostImp.class);
    private SplitHttpClient _client;
    private final TelemetryRuntimeProducer _telemetryRuntimeProducer;

    public HttpPostImp(SplitHttpClient client, TelemetryRuntimeProducer telemetryRuntimeProducer) {
        this._client = client;
        this._telemetryRuntimeProducer = Preconditions.checkNotNull(telemetryRuntimeProducer);
    }

    public void post(URI uri, Object object, String posted, HttpParamsWrapper httpParamsWrapper) {
        long initTime = System.currentTimeMillis();
        try {
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            headers.put("Content-Type", Collections.singletonList("application/json"));
            SplitHttpResponse response = this._client.post(uri, Json.toJson(object), headers);
            if (response.statusCode() < 200 || response.statusCode() >= 300) {
                this._telemetryRuntimeProducer.recordSyncError(httpParamsWrapper.getResourceEnum(), response.statusCode());
                return;
            }
            this._telemetryRuntimeProducer.recordSyncLatency(httpParamsWrapper.getHttpLatenciesEnum(), System.currentTimeMillis() - initTime);
            this._telemetryRuntimeProducer.recordSuccessfulSync(httpParamsWrapper.getLastSynchronizationRecordsEnum(), System.currentTimeMillis());
        }
        catch (Throwable t2) {
            _logger.warn("Exception when posting " + posted + object, t2);
        }
    }
}

