/*
 * Decompiled with CFR 0.152.
 */
package split.org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import split.org.apache.hc.core5.annotation.Contract;
import split.org.apache.hc.core5.annotation.Internal;
import split.org.apache.hc.core5.annotation.ThreadingBehavior;
import split.org.apache.hc.core5.concurrent.FutureCallback;
import split.org.apache.hc.core5.function.Callback;
import split.org.apache.hc.core5.http2.impl.nio.ServerH2PrefaceHandler;
import split.org.apache.hc.core5.http2.impl.nio.ServerH2StreamMultiplexerFactory;
import split.org.apache.hc.core5.reactor.ProtocolIOSession;
import split.org.apache.hc.core5.reactor.ProtocolUpgradeHandler;
import split.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
@Internal
public class ServerH2UpgradeHandler
implements ProtocolUpgradeHandler {
    private final ServerH2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final Callback<Exception> exceptionCallback;

    public ServerH2UpgradeHandler(ServerH2StreamMultiplexerFactory http2StreamHandlerFactory, Callback<Exception> exceptionCallback) {
        this.http2StreamHandlerFactory = Args.notNull(http2StreamHandlerFactory, "HTTP/2 stream handler factory");
        this.exceptionCallback = exceptionCallback;
    }

    @Override
    public void upgrade(ProtocolIOSession ioSession, FutureCallback<ProtocolIOSession> callback) {
        ServerH2PrefaceHandler protocolNegotiator = new ServerH2PrefaceHandler(ioSession, this.http2StreamHandlerFactory, callback, this.exceptionCallback);
        ioSession.upgrade(protocolNegotiator);
        try {
            protocolNegotiator.connected(ioSession);
        }
        catch (IOException ex) {
            protocolNegotiator.exception(ioSession, ex);
        }
    }
}

