/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.dtos.SplitChange;
import io.split.client.dtos.SplitChangesOldPayloadDto;
import io.split.client.utils.InputStreamProvider;
import io.split.client.utils.Json;
import io.split.client.utils.LocalhostSanitizer;
import io.split.client.utils.Utils;
import io.split.engine.common.FetchOptions;
import io.split.engine.experiments.SplitChangeFetcher;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.gson.JsonObject;
import split.com.google.gson.stream.JsonReader;

public class JsonLocalhostSplitChangeFetcher
implements SplitChangeFetcher {
    private static final Logger _log = LoggerFactory.getLogger(JsonLocalhostSplitChangeFetcher.class);
    private final InputStreamProvider _inputStreamProvider;
    private byte[] lastHashFeatureFlags;
    private byte[] lastHashRuleBasedSegments;

    public JsonLocalhostSplitChangeFetcher(InputStreamProvider inputStreamProvider) {
        this._inputStreamProvider = inputStreamProvider;
        this.lastHashFeatureFlags = new byte[0];
        this.lastHashRuleBasedSegments = new byte[0];
    }

    @Override
    public SplitChange fetch(long since, long sinceRBS, FetchOptions options) {
        try {
            JsonReader jsonReader = new JsonReader(new BufferedReader(new InputStreamReader(this._inputStreamProvider.get(), StandardCharsets.UTF_8)));
            if (this.checkOldSpec(new JsonReader(new BufferedReader(new InputStreamReader(this._inputStreamProvider.get(), StandardCharsets.UTF_8))))) {
                return Json.fromJson(jsonReader, SplitChangesOldPayloadDto.class).toSplitChange();
            }
            SplitChange splitChange = Json.fromJson(jsonReader, SplitChange.class);
            return this.processSplitChange(splitChange, since, sinceRBS);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem fetching splitChanges: " + e.getMessage(), e);
        }
    }

    private boolean checkOldSpec(JsonReader jsonReader) {
        return Json.fromJson(jsonReader, JsonObject.class).has("splits");
    }

    private SplitChange processSplitChange(SplitChange splitChange, long changeNumber, long changeNumberRBS) throws NoSuchAlgorithmException {
        SplitChange splitChangeToProcess = LocalhostSanitizer.sanitization(splitChange);
        if (Utils.checkExitConditions(splitChangeToProcess.featureFlags, changeNumber) || Utils.checkExitConditions(splitChangeToProcess.ruleBasedSegments, changeNumberRBS)) {
            _log.warn("The till is lower than the change number or different to -1");
            return null;
        }
        byte[] currHashFeatureFlags = this.getStringDigest(splitChange.featureFlags.d.toString());
        byte[] currHashRuleBasedSegments = this.getStringDigest(splitChange.ruleBasedSegments.d.toString());
        if (Arrays.equals(this.lastHashFeatureFlags, currHashFeatureFlags) || splitChangeToProcess.featureFlags.t == -1L) {
            splitChangeToProcess.featureFlags.t = changeNumber;
        }
        if (Arrays.equals(this.lastHashRuleBasedSegments, currHashRuleBasedSegments) || splitChangeToProcess.ruleBasedSegments.t == -1L) {
            splitChangeToProcess.ruleBasedSegments.t = changeNumberRBS;
        }
        this.lastHashFeatureFlags = currHashFeatureFlags;
        this.lastHashRuleBasedSegments = currHashRuleBasedSegments;
        splitChangeToProcess.featureFlags.s = changeNumber;
        splitChangeToProcess.ruleBasedSegments.s = changeNumberRBS;
        return splitChangeToProcess;
    }

    private byte[] getStringDigest(String json) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        digest.reset();
        digest.update(json.getBytes());
        return digest.digest();
    }
}

