/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.impressions.filters;

import io.split.client.impressions.filters.Filter;
import split.com.google.common.base.Charsets;
import split.com.google.common.hash.BloomFilter;
import split.com.google.common.hash.Funnels;

public class BloomFilterImp
implements Filter {
    private BloomFilter<String> bloomFilter;
    private final int size;
    private final double errorMargin;

    public BloomFilterImp(int size, double errorMargin) {
        this.size = size;
        this.errorMargin = errorMargin;
        this.bloomFilter = BloomFilter.create(Funnels.stringFunnel(Charsets.UTF_8), size, errorMargin);
    }

    @Override
    public boolean add(String data) {
        return this.bloomFilter.put(data);
    }

    @Override
    public boolean contains(String data) {
        return this.bloomFilter.mightContain(data);
    }

    @Override
    public void clear() {
        this.bloomFilter = BloomFilter.create(Funnels.stringFunnel(Charsets.UTF_16), this.size, this.errorMargin);
    }
}

