/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.common;

import io.split.client.impressions.ImpressionsManager;
import io.split.client.impressions.UniqueKeysTracker;
import io.split.engine.common.SplitTasks;
import io.split.engine.common.Synchronizer;
import io.split.engine.sse.dtos.SplitKillNotification;
import io.split.telemetry.synchronizer.TelemetrySyncTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerSynchronizer
implements Synchronizer {
    private static final Logger _log = LoggerFactory.getLogger(ConsumerSynchronizer.class);
    private final UniqueKeysTracker _uniqueKeysTracker;
    private final ImpressionsManager _impressionManager;
    private final TelemetrySyncTask _telemetrySyncTask;

    public ConsumerSynchronizer(SplitTasks splitTasks) {
        this._uniqueKeysTracker = splitTasks.getUniqueKeysTracker();
        this._impressionManager = splitTasks.getImpressionManager();
        this._telemetrySyncTask = splitTasks.getTelemetrySyncTask();
    }

    @Override
    public boolean syncAll() {
        return false;
    }

    @Override
    public void startPeriodicFetching() {
    }

    @Override
    public void stopPeriodicFetching() {
    }

    @Override
    public void refreshSplits(Long targetChangeNumber, Long ruleBasedSegmentChangeNumber) {
    }

    @Override
    public void localKillSplit(SplitKillNotification splitKillNotification) {
    }

    @Override
    public void refreshSegment(String segmentName, Long targetChangeNumber) {
    }

    @Override
    public void startPeriodicDataRecording() {
        try {
            this._impressionManager.start();
        }
        catch (Exception e) {
            _log.error("Error trying to init Impression Manager synchronizer task.", (Throwable)e);
        }
        if (this._uniqueKeysTracker != null) {
            try {
                this._uniqueKeysTracker.start();
            }
            catch (Exception e) {
                _log.error("Error trying to init Unique Keys Tracker synchronizer task.", (Throwable)e);
            }
        }
        try {
            this._telemetrySyncTask.startScheduledTask();
        }
        catch (Exception e) {
            _log.error("Error trying to Telemetry synchronizer task.", (Throwable)e);
        }
    }

    @Override
    public void stopPeriodicDataRecording() {
        this._impressionManager.close();
        _log.info("Successful shutdown of impressions manager");
        if (this._uniqueKeysTracker != null) {
            this._uniqueKeysTracker.stop();
            _log.info("Successful stop of UniqueKeysTracker");
        }
        this._telemetrySyncTask.stopScheduledTask();
        _log.info("Successful shutdown of telemetry sync task");
    }

    @Override
    public void forceRefreshSegment(String segmentName) {
    }
}

