/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.experiments;

import io.split.client.dtos.ExcludedSegments;
import io.split.engine.experiments.ParsedCondition;
import io.split.engine.matchers.AttributeMatcher;
import io.split.engine.matchers.UserDefinedSegmentMatcher;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import split.com.google.common.collect.ImmutableList;

public class ParsedRuleBasedSegment {
    private final String _ruleBasedSegment;
    private final ImmutableList<ParsedCondition> _parsedCondition;
    private final String _trafficTypeName;
    private final long _changeNumber;
    private final List<String> _excludedKeys;
    private final List<ExcludedSegments> _excludedSegments;

    public static ParsedRuleBasedSegment createParsedRuleBasedSegmentForTests(String ruleBasedSegment, List<ParsedCondition> matcherAndSplits, String trafficTypeName, long changeNumber, List<String> excludedKeys, List<ExcludedSegments> excludedSegments) {
        return new ParsedRuleBasedSegment(ruleBasedSegment, matcherAndSplits, trafficTypeName, changeNumber, excludedKeys, excludedSegments);
    }

    public ParsedRuleBasedSegment(String ruleBasedSegment, List<ParsedCondition> matcherAndSplits, String trafficTypeName, long changeNumber, List<String> excludedKeys, List<ExcludedSegments> excludedSegments) {
        this._ruleBasedSegment = ruleBasedSegment;
        this._parsedCondition = ImmutableList.copyOf(matcherAndSplits);
        this._trafficTypeName = trafficTypeName;
        this._changeNumber = changeNumber;
        this._excludedKeys = excludedKeys;
        this._excludedSegments = excludedSegments;
    }

    public String ruleBasedSegment() {
        return this._ruleBasedSegment;
    }

    public List<ParsedCondition> parsedConditions() {
        return this._parsedCondition;
    }

    public String trafficTypeName() {
        return this._trafficTypeName;
    }

    public long changeNumber() {
        return this._changeNumber;
    }

    public List<String> excludedKeys() {
        return this._excludedKeys;
    }

    public List<ExcludedSegments> excludedSegments() {
        return this._excludedSegments;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._ruleBasedSegment.hashCode();
        result = 31 * result + this._parsedCondition.hashCode();
        result = 31 * result + (this._trafficTypeName == null ? 0 : this._trafficTypeName.hashCode());
        result = 31 * result + (int)(this._changeNumber ^ this._changeNumber >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ParsedRuleBasedSegment)) {
            return false;
        }
        ParsedRuleBasedSegment other = (ParsedRuleBasedSegment)obj;
        return this._ruleBasedSegment.equals(other._ruleBasedSegment) && this._parsedCondition.equals(other._parsedCondition) && this._trafficTypeName == null ? other._trafficTypeName == null : this._trafficTypeName.equals(other._trafficTypeName) && this._changeNumber == other._changeNumber;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("name:");
        bldr.append(this._ruleBasedSegment);
        bldr.append(", parsedConditions:");
        bldr.append(this._parsedCondition);
        bldr.append(", trafficTypeName:");
        bldr.append(this._trafficTypeName);
        bldr.append(", changeNumber:");
        bldr.append(this._changeNumber);
        return bldr.toString();
    }

    public Set<String> getSegmentsNames() {
        Set<String> segmentNames = this.excludedSegments().stream().filter(ExcludedSegments::isStandard).map(ExcludedSegments::getSegmentName).collect(Collectors.toSet());
        segmentNames.addAll(this.parsedConditions().stream().flatMap(parsedCondition -> parsedCondition.matcher().attributeMatchers().stream()).filter(ParsedRuleBasedSegment::isSegmentMatcher).map(ParsedRuleBasedSegment::asSegmentMatcherForEach).map(UserDefinedSegmentMatcher::getSegmentName).collect(Collectors.toSet()));
        return segmentNames;
    }

    private static boolean isSegmentMatcher(AttributeMatcher attributeMatcher) {
        return ((AttributeMatcher.NegatableMatcher)attributeMatcher.matcher()).delegate() instanceof UserDefinedSegmentMatcher;
    }

    private static UserDefinedSegmentMatcher asSegmentMatcherForEach(AttributeMatcher attributeMatcher) {
        return (UserDefinedSegmentMatcher)((AttributeMatcher.NegatableMatcher)attributeMatcher.matcher()).delegate();
    }
}

