/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.experiments;

import io.split.client.dtos.SplitChange;
import io.split.client.exceptions.UriTooLongException;
import io.split.client.interceptors.FlagSetsFilter;
import io.split.client.utils.FeatureFlagProcessor;
import io.split.client.utils.FeatureFlagsToUpdate;
import io.split.client.utils.RuleBasedSegmentProcessor;
import io.split.client.utils.RuleBasedSegmentsToUpdate;
import io.split.client.utils.Utils;
import io.split.engine.common.FetchOptions;
import io.split.engine.experiments.FetchResult;
import io.split.engine.experiments.RuleBasedSegmentParser;
import io.split.engine.experiments.SplitChangeFetcher;
import io.split.engine.experiments.SplitFetcher;
import io.split.engine.experiments.SplitParser;
import io.split.storages.RuleBasedSegmentCacheProducer;
import io.split.storages.SplitCacheProducer;
import io.split.telemetry.domain.enums.LastSynchronizationRecordsEnum;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;

public class SplitFetcherImp
implements SplitFetcher {
    private static final Logger _log = LoggerFactory.getLogger(SplitFetcherImp.class);
    private final SplitParser _parser;
    private final SplitChangeFetcher _splitChangeFetcher;
    private final SplitCacheProducer _splitCacheProducer;
    private final Object _lock = new Object();
    private final TelemetryRuntimeProducer _telemetryRuntimeProducer;
    private final FlagSetsFilter _flagSetsFilter;
    private final RuleBasedSegmentCacheProducer _ruleBasedSegmentCacheProducer;
    private final RuleBasedSegmentParser _parserRBS;

    public SplitFetcherImp(SplitChangeFetcher splitChangeFetcher, SplitParser parser, SplitCacheProducer splitCacheProducer, TelemetryRuntimeProducer telemetryRuntimeProducer, FlagSetsFilter flagSetsFilter, RuleBasedSegmentParser parserRBS, RuleBasedSegmentCacheProducer ruleBasedSegmentCacheProducer) {
        this._splitChangeFetcher = Preconditions.checkNotNull(splitChangeFetcher);
        this._parser = Preconditions.checkNotNull(parser);
        this._parserRBS = Preconditions.checkNotNull(parserRBS);
        this._splitCacheProducer = Preconditions.checkNotNull(splitCacheProducer);
        this._ruleBasedSegmentCacheProducer = Preconditions.checkNotNull(ruleBasedSegmentCacheProducer);
        this._telemetryRuntimeProducer = Preconditions.checkNotNull(telemetryRuntimeProducer);
        this._flagSetsFilter = flagSetsFilter;
    }

    @Override
    public FetchResult forceRefresh(FetchOptions options) {
        _log.debug("Force Refresh feature flags starting ...");
        long INITIAL_CN = this._splitCacheProducer.getChangeNumber();
        long RBS_INITIAL_CN = this._ruleBasedSegmentCacheProducer.getChangeNumber();
        HashSet<String> segments = new HashSet<String>();
        try {
            long endRBS;
            long startRBS;
            long end;
            long start;
            do {
                start = this._splitCacheProducer.getChangeNumber();
                startRBS = this._ruleBasedSegmentCacheProducer.getChangeNumber();
                segments.addAll(this.runWithoutExceptionHandling(options));
                end = this._splitCacheProducer.getChangeNumber();
                endRBS = this._ruleBasedSegmentCacheProducer.getChangeNumber();
                FetchOptions.Builder optionsBuilder = new FetchOptions.Builder(options);
                if (INITIAL_CN == start) {
                    optionsBuilder.targetChangeNumber(FetchOptions.DEFAULT_TARGET_CHANGENUMBER);
                }
                if (RBS_INITIAL_CN == startRBS) {
                    optionsBuilder.targetChangeNumberRBS(FetchOptions.DEFAULT_TARGET_CHANGENUMBER);
                }
                options = optionsBuilder.build();
            } while (start < end || startRBS < endRBS);
            return new FetchResult(true, false, segments);
        }
        catch (UriTooLongException u) {
            return new FetchResult(false, false, new HashSet<String>());
        }
        catch (InterruptedException e) {
            _log.warn("Interrupting split fetcher task");
            Thread.currentThread().interrupt();
            return new FetchResult(false, true, new HashSet<String>());
        }
        catch (Exception e) {
            _log.error("SplitFetcherImp failed: " + e.getMessage());
            if (_log.isDebugEnabled()) {
                _log.debug("Reason:", (Throwable)e);
            }
            return new FetchResult(false, true, new HashSet<String>());
        }
    }

    @Override
    public void run() {
        this.forceRefresh(new FetchOptions.Builder().cacheControlHeaders(false).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> runWithoutExceptionHandling(FetchOptions options) throws InterruptedException, UriTooLongException {
        SplitChange change = this._splitChangeFetcher.fetch(this._splitCacheProducer.getChangeNumber(), this._ruleBasedSegmentCacheProducer.getChangeNumber(), options);
        Set<String> segments = new HashSet<String>();
        if (change == null) {
            throw new IllegalStateException("SplitChange was null");
        }
        if (change.clearCache) {
            this._splitCacheProducer.clear();
            this._ruleBasedSegmentCacheProducer.clear();
        }
        if (Utils.checkExitConditions(change.featureFlags, this._splitCacheProducer.getChangeNumber()) || Utils.checkExitConditions(change.ruleBasedSegments, this._ruleBasedSegmentCacheProducer.getChangeNumber())) {
            return segments;
        }
        if (change.featureFlags.d.isEmpty()) {
            this._splitCacheProducer.setChangeNumber(change.featureFlags.t);
        }
        if (change.ruleBasedSegments.d.isEmpty()) {
            this._ruleBasedSegmentCacheProducer.setChangeNumber(change.ruleBasedSegments.t);
        }
        if (change.featureFlags.d.isEmpty() && change.ruleBasedSegments.d.isEmpty()) {
            return segments;
        }
        Object object = this._lock;
        synchronized (object) {
            if (Utils.checkExitConditions(change.featureFlags, this._splitCacheProducer.getChangeNumber()) || Utils.checkExitConditions(change.ruleBasedSegments, this._ruleBasedSegmentCacheProducer.getChangeNumber())) {
                return segments;
            }
            FeatureFlagsToUpdate featureFlagsToUpdate = FeatureFlagProcessor.processFeatureFlagChanges(this._parser, change.featureFlags.d, this._flagSetsFilter);
            segments = featureFlagsToUpdate.getSegments();
            this._splitCacheProducer.update(featureFlagsToUpdate.getToAdd(), featureFlagsToUpdate.getToRemove(), change.featureFlags.t);
            RuleBasedSegmentsToUpdate ruleBasedSegmentsToUpdate = RuleBasedSegmentProcessor.processRuleBasedSegmentChanges(this._parserRBS, change.ruleBasedSegments.d);
            segments.addAll(ruleBasedSegmentsToUpdate.getSegments());
            this._ruleBasedSegmentCacheProducer.update(ruleBasedSegmentsToUpdate.getToAdd(), ruleBasedSegmentsToUpdate.getToRemove(), change.ruleBasedSegments.t);
            this._telemetryRuntimeProducer.recordSuccessfulSync(LastSynchronizationRecordsEnum.SPLITS, System.currentTimeMillis());
        }
        return segments;
    }
}

