/*
 * Decompiled with CFR 0.152.
 */
package split.org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.org.apache.hc.client5.http.ClientProtocolException;
import split.org.apache.hc.client5.http.HttpRoute;
import split.org.apache.hc.client5.http.SchemePortResolver;
import split.org.apache.hc.client5.http.config.Configurable;
import split.org.apache.hc.client5.http.config.RequestConfig;
import split.org.apache.hc.client5.http.impl.ConnectionShutdownException;
import split.org.apache.hc.client5.http.impl.DefaultClientConnectionReuseStrategy;
import split.org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import split.org.apache.hc.client5.http.impl.ExecSupport;
import split.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import split.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import split.org.apache.hc.client5.http.impl.classic.InternalExecRuntime;
import split.org.apache.hc.client5.http.impl.classic.ResponseEntityProxy;
import split.org.apache.hc.client5.http.io.HttpClientConnectionManager;
import split.org.apache.hc.client5.http.protocol.HttpClientContext;
import split.org.apache.hc.client5.http.protocol.RequestClientConnControl;
import split.org.apache.hc.client5.http.routing.RoutingSupport;
import split.org.apache.hc.core5.annotation.Contract;
import split.org.apache.hc.core5.annotation.ThreadingBehavior;
import split.org.apache.hc.core5.concurrent.CancellableDependency;
import split.org.apache.hc.core5.http.ClassicHttpRequest;
import split.org.apache.hc.core5.http.ClassicHttpResponse;
import split.org.apache.hc.core5.http.ConnectionReuseStrategy;
import split.org.apache.hc.core5.http.EntityDetails;
import split.org.apache.hc.core5.http.HttpEntity;
import split.org.apache.hc.core5.http.HttpException;
import split.org.apache.hc.core5.http.HttpHost;
import split.org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import split.org.apache.hc.core5.http.protocol.DefaultHttpProcessor;
import split.org.apache.hc.core5.http.protocol.HttpContext;
import split.org.apache.hc.core5.http.protocol.HttpProcessor;
import split.org.apache.hc.core5.http.protocol.RequestContent;
import split.org.apache.hc.core5.http.protocol.RequestTargetHost;
import split.org.apache.hc.core5.http.protocol.RequestUserAgent;
import split.org.apache.hc.core5.io.CloseMode;
import split.org.apache.hc.core5.net.URIAuthority;
import split.org.apache.hc.core5.util.Args;
import split.org.apache.hc.core5.util.TimeValue;
import split.org.apache.hc.core5.util.VersionInfo;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class MinimalHttpClient
extends CloseableHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(MinimalHttpClient.class);
    private final HttpClientConnectionManager connManager;
    private final ConnectionReuseStrategy reuseStrategy;
    private final SchemePortResolver schemePortResolver;
    private final HttpRequestExecutor requestExecutor;
    private final HttpProcessor httpProcessor;

    MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.reuseStrategy = DefaultClientConnectionReuseStrategy.INSTANCE;
        this.schemePortResolver = DefaultSchemePortResolver.INSTANCE;
        this.requestExecutor = new HttpRequestExecutor(this.reuseStrategy);
        this.httpProcessor = new DefaultHttpProcessor(new RequestContent(), new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent(VersionInfo.getSoftwareInfo("Apache-HttpClient", "split.org.apache.hc.client5", this.getClass())));
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, ClassicHttpRequest request, HttpContext context) throws IOException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        if (request.getScheme() == null) {
            request.setScheme(target.getSchemeName());
        }
        if (request.getAuthority() == null) {
            request.setAuthority(new URIAuthority(target));
        }
        HttpClientContext clientContext = HttpClientContext.castOrCreate(context);
        RequestConfig config = null;
        if (request instanceof Configurable) {
            config = ((Configurable)((Object)request)).getConfig();
        }
        if (config != null) {
            clientContext.setRequestConfig(config);
        }
        HttpRoute route = new HttpRoute(RoutingSupport.normalize(target, this.schemePortResolver));
        String exchangeId = ExecSupport.getNextExchangeId();
        clientContext.setExchangeId(exchangeId);
        InternalExecRuntime execRuntime = new InternalExecRuntime(LOG, this.connManager, this.requestExecutor, request instanceof CancellableDependency ? (CancellableDependency)((Object)request) : null);
        try {
            if (!execRuntime.isEndpointAcquired()) {
                execRuntime.acquireEndpoint(exchangeId, route, null, clientContext);
            }
            if (!execRuntime.isEndpointConnected()) {
                execRuntime.connectEndpoint(clientContext);
            }
            clientContext.setRequest(request);
            clientContext.setRoute(route);
            this.httpProcessor.process(request, (EntityDetails)request.getEntity(), (HttpContext)clientContext);
            ClassicHttpResponse response = execRuntime.execute(exchangeId, request, clientContext);
            this.httpProcessor.process(response, (EntityDetails)response.getEntity(), (HttpContext)clientContext);
            if (this.reuseStrategy.keepAlive(request, response, clientContext)) {
                execRuntime.markConnectionReusable(null, TimeValue.NEG_ONE_MILLISECOND);
            } else {
                execRuntime.markConnectionNonReusable();
            }
            HttpEntity entity = response.getEntity();
            if (entity == null || !entity.isStreaming()) {
                execRuntime.releaseEndpoint();
                return new CloseableHttpResponse(response);
            }
            ResponseEntityProxy.enhance(response, execRuntime);
            return new CloseableHttpResponse(response, execRuntime);
        }
        catch (ConnectionShutdownException ex) {
            InterruptedIOException ioex = new InterruptedIOException("Connection has been shut down");
            ioex.initCause(ex);
            execRuntime.discardEndpoint();
            throw ioex;
        }
        catch (HttpException httpException) {
            execRuntime.discardEndpoint();
            throw new ClientProtocolException(httpException);
        }
        catch (IOException | RuntimeException ex) {
            execRuntime.discardEndpoint();
            throw ex;
        }
        catch (Error error) {
            this.connManager.close(CloseMode.IMMEDIATE);
            throw error;
        }
    }

    @Override
    public void close() throws IOException {
        this.connManager.close();
    }

    @Override
    public void close(CloseMode closeMode) {
        this.connManager.close(closeMode);
    }
}

