/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.segments;

import io.split.cache.SegmentCache;
import io.split.client.dtos.SegmentChange;
import io.split.engine.SDKReadinessGates;
import io.split.engine.common.FetchOptions;
import io.split.engine.segments.SegmentChangeFetcher;
import io.split.engine.segments.SegmentFetcher;
import io.split.telemetry.domain.enums.LastSynchronizationRecordsEnum;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.base.Preconditions;

public class SegmentFetcherImp
implements SegmentFetcher {
    private static final Logger _log = LoggerFactory.getLogger(SegmentFetcherImp.class);
    private final String _segmentName;
    private final SegmentChangeFetcher _segmentChangeFetcher;
    private final SegmentCache _segmentCache;
    private final SDKReadinessGates _gates;
    private final TelemetryRuntimeProducer _telemetryRuntimeProducer;
    private final Object _lock = new Object();

    public SegmentFetcherImp(String segmentName, SegmentChangeFetcher segmentChangeFetcher, SDKReadinessGates gates, SegmentCache segmentCache, TelemetryRuntimeProducer telemetryRuntimeProducer) {
        this._segmentName = Preconditions.checkNotNull(segmentName);
        this._segmentChangeFetcher = Preconditions.checkNotNull(segmentChangeFetcher);
        this._segmentCache = Preconditions.checkNotNull(segmentCache);
        this._gates = Preconditions.checkNotNull(gates);
        this._telemetryRuntimeProducer = Preconditions.checkNotNull(telemetryRuntimeProducer);
        this._segmentCache.updateSegment(segmentName, new ArrayList<String>(), new ArrayList<String>());
    }

    @Override
    public void fetch(FetchOptions opts) {
        block2: {
            try {
                this.callLoopRun(opts);
            }
            catch (Throwable t) {
                _log.error("RefreshableSegmentFetcher failed: " + t.getMessage());
                if (!_log.isDebugEnabled()) break block2;
                _log.debug("Reason:", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithoutExceptionHandling(FetchOptions options) {
        long initTime = System.currentTimeMillis();
        SegmentChange change = this._segmentChangeFetcher.fetch(this._segmentName, this._segmentCache.getChangeNumber(this._segmentName), options);
        if (change == null) {
            throw new IllegalStateException("SegmentChange was null");
        }
        if (change.till == this._segmentCache.getChangeNumber(this._segmentName)) {
            return;
        }
        if (change.since != this._segmentCache.getChangeNumber(this._segmentName) || change.since < this._segmentCache.getChangeNumber(this._segmentName)) {
            return;
        }
        if (change.added.isEmpty() && change.removed.isEmpty()) {
            this._segmentCache.setChangeNumber(this._segmentName, change.till);
            return;
        }
        Object object = this._lock;
        synchronized (object) {
            if (change.since != this._segmentCache.getChangeNumber(this._segmentName) || change.till < this._segmentCache.getChangeNumber(this._segmentName)) {
                return;
            }
            this._segmentCache.updateSegment(this._segmentName, change.added, change.removed);
            if (!change.added.isEmpty()) {
                _log.info(this._segmentName + " added keys: " + this.summarize(change.added));
            }
            if (!change.removed.isEmpty()) {
                _log.info(this._segmentName + " removed keys: " + this.summarize(change.removed));
            }
            this._segmentCache.setChangeNumber(this._segmentName, change.till);
            this._telemetryRuntimeProducer.recordSuccessfulSync(LastSynchronizationRecordsEnum.SEGMENTS, System.currentTimeMillis());
        }
    }

    private String summarize(List<String> changes) {
        StringBuilder bldr = new StringBuilder();
        bldr.append("[");
        for (int i = 0; i < Math.min(3, changes.size()); ++i) {
            if (i != 0) {
                bldr.append(", ");
            }
            bldr.append(changes.get(i));
        }
        if (changes.size() > 3) {
            bldr.append("... ");
            bldr.append(changes.size() - 3);
            bldr.append(" others");
        }
        bldr.append("]");
        return bldr.toString();
    }

    @VisibleForTesting
    void callLoopRun(FetchOptions opts) {
        long end;
        long start;
        long INITIAL_CN = this._segmentCache.getChangeNumber(this._segmentName);
        do {
            start = this._segmentCache.getChangeNumber(this._segmentName);
            this.runWithoutExceptionHandling(opts);
            if (INITIAL_CN != start) continue;
            opts = new FetchOptions.Builder(opts).targetChangeNumber(FetchOptions.DEFAULT_TARGET_CHANGENUMBER).build();
        } while (start < (end = this._segmentCache.getChangeNumber(this._segmentName)));
    }

    @Override
    public boolean runWhitCacheHeader() {
        return this.fetchAndUpdate(new FetchOptions.Builder().cacheControlHeaders(true).build());
    }

    @VisibleForTesting
    boolean fetchAndUpdate(FetchOptions opts) {
        try {
            this.callLoopRun(opts);
            return true;
        }
        catch (Throwable t) {
            _log.error("RefreshableSegmentFetcher failed: " + t.getMessage());
            if (_log.isDebugEnabled()) {
                _log.debug("Reason:", t);
            }
            return false;
        }
    }

    @Override
    public void fetchAll() {
        this.fetchAndUpdate(new FetchOptions.Builder().build());
    }
}

