/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.dtos.SplitChange;
import io.split.client.utils.Json;
import io.split.client.utils.Utils;
import io.split.engine.common.FetchOptions;
import io.split.engine.experiments.SplitChangeFetcher;
import io.split.telemetry.domain.enums.HTTPLatenciesEnum;
import io.split.telemetry.domain.enums.ResourceEnum;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.base.Preconditions;

public final class HttpSplitChangeFetcher
implements SplitChangeFetcher {
    private static final Logger _log = LoggerFactory.getLogger(HttpSplitChangeFetcher.class);
    private static final String SINCE = "since";
    private static final String TILL = "till";
    private static final String PREFIX = "splitChangeFetcher";
    private static final String HEADER_CACHE_CONTROL_NAME = "Cache-Control";
    private static final String HEADER_CACHE_CONTROL_VALUE = "no-cache";
    private static final String HEADER_FASTLY_DEBUG_NAME = "Fastly-Debug";
    private static final String HEADER_FASTLY_DEBUG_VALUE = "1";
    private final CloseableHttpClient _client;
    private final URI _target;
    private final TelemetryRuntimeProducer _telemetryRuntimeProducer;

    public static HttpSplitChangeFetcher create(CloseableHttpClient client, URI root, TelemetryRuntimeProducer telemetryRuntimeProducer) throws URISyntaxException {
        return new HttpSplitChangeFetcher(client, Utils.appendPath(root, "api/splitChanges"), telemetryRuntimeProducer);
    }

    private HttpSplitChangeFetcher(CloseableHttpClient client, URI uri, TelemetryRuntimeProducer telemetryRuntimeProducer) {
        this._client = client;
        this._target = uri;
        Preconditions.checkNotNull(this._target);
        this._telemetryRuntimeProducer = Preconditions.checkNotNull(telemetryRuntimeProducer);
    }

    long makeRandomTill() {
        return -1L * (long)Math.floor(Math.random() * Math.pow(2.0, 63.0));
    }

    @Override
    public SplitChange fetch(long since, FetchOptions options) {
        SplitChange splitChange;
        long start = System.currentTimeMillis();
        CloseableHttpResponse response = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(this._target).addParameter(SINCE, "" + since);
            if (options.hasCustomCN()) {
                uriBuilder.addParameter(TILL, "" + options.targetCN());
            }
            URI uri = uriBuilder.build();
            HttpGet request = new HttpGet(uri);
            if (options.cacheControlHeadersEnabled()) {
                request.setHeader(HEADER_CACHE_CONTROL_NAME, (Object)HEADER_CACHE_CONTROL_VALUE);
            }
            if (options.fastlyDebugHeaderEnabled()) {
                request.addHeader(HEADER_FASTLY_DEBUG_NAME, (Object)HEADER_FASTLY_DEBUG_VALUE);
            }
            response = this._client.execute((ClassicHttpRequest)request);
            options.handleResponseHeaders(Arrays.stream(response.getHeaders()).collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue)));
            int statusCode = response.getCode();
            if (statusCode < 200 || statusCode >= 300) {
                this._telemetryRuntimeProducer.recordSyncError(ResourceEnum.SPLIT_SYNC, statusCode);
                throw new IllegalStateException("Could not retrieve splitChanges; http return code " + statusCode);
            }
            String json = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            if (_log.isDebugEnabled()) {
                _log.debug("Received json: " + json);
            }
            splitChange = Json.fromJson(json, SplitChange.class);
            this._telemetryRuntimeProducer.recordSyncLatency(HTTPLatenciesEnum.SPLITS, System.currentTimeMillis() - start);
        }
        catch (Throwable t) {
            try {
                throw new IllegalStateException("Problem fetching splitChanges: " + t.getMessage(), t);
            }
            catch (Throwable throwable) {
                this._telemetryRuntimeProducer.recordSyncLatency(HTTPLatenciesEnum.SPLITS, System.currentTimeMillis() - start);
                Utils.forceClose(response);
                throw throwable;
            }
        }
        Utils.forceClose(response);
        return splitChange;
    }

    @VisibleForTesting
    URI getTarget() {
        return this._target;
    }
}

