/*
 * Decompiled with CFR 0.152.
 */
package io.split.telemetry.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicLongArray {
    private AtomicLong[] array;
    private static final int MAX_LENGTH = 23;
    private static final Logger _log = LoggerFactory.getLogger(AtomicLongArray.class);

    public AtomicLongArray(int size) {
        if (size <= 0) {
            _log.error("Invalid array size. Using default size: 23");
            size = 23;
        }
        this.array = new AtomicLong[size];
        IntStream.range(0, this.array.length).forEach(x -> {
            this.array[x] = new AtomicLong();
        });
    }

    public void increment(int index) {
        if (index < 0 || index >= this.array.length) {
            _log.error("Index is out of bounds. Did not incremented.");
            return;
        }
        this.array[index].getAndIncrement();
    }

    public List<Long> fetchAndClearAll() {
        ArrayList<Long> listValues = new ArrayList<Long>();
        for (AtomicLong a : this.array) {
            listValues.add(a.longValue());
        }
        IntStream.range(0, this.array.length).forEach(x -> {
            this.array[x] = new AtomicLong();
        });
        return listValues;
    }
}

