/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.collect.ConcurrentHashMultiset;
import split.com.google.common.collect.Multiset;

public class ApiKeyCounter {
    private static final Logger _log = LoggerFactory.getLogger(ApiKeyCounter.class);
    private static final Multiset<String> USED_API_KEYS = ConcurrentHashMultiset.create();

    private ApiKeyCounter() {
    }

    public static ApiKeyCounter getApiKeyCounterInstance() {
        return ApyKeyCounterHolder.INSTANCE;
    }

    public void add(String apiKey) {
        if (USED_API_KEYS.contains(apiKey)) {
            String message = String.format("factory instantiation: You already have %s with this API Key. We recommend keeping only one instance of the factory at all times (Singleton pattern) and reusing it throughout your application.", USED_API_KEYS.count(apiKey) == 1 ? "1 factory" : String.format("%s factories", USED_API_KEYS.count(apiKey)));
            _log.warn(message);
        } else if (!USED_API_KEYS.isEmpty()) {
            String message = "factory instantiation: You already have an instance of the Split factory. Make sure you definitely want this additional instance. We recommend keeping only one instance of the factory at all times (Singleton pattern) and reusing it throughout your application.\u201c";
            _log.warn(message);
        }
        USED_API_KEYS.add(apiKey);
    }

    public void remove(String apiKey) {
        USED_API_KEYS.remove(apiKey);
    }

    @VisibleForTesting
    boolean isApiKeyPresent(String apiKey) {
        return USED_API_KEYS.contains(apiKey);
    }

    @VisibleForTesting
    int getCount(String apiKey) {
        return USED_API_KEYS.count(apiKey);
    }

    public Map<String, Long> getFactoryInstances() {
        HashMap<String, Long> factoryInstances = new HashMap<String, Long>();
        for (String factory : USED_API_KEYS) {
            factoryInstances.putIfAbsent(factory, new Long(this.getCount(factory)));
        }
        return factoryInstances;
    }

    public void clearApiKeys() {
        USED_API_KEYS.clear();
    }

    private static class ApyKeyCounterHolder {
        private static final ApiKeyCounter INSTANCE = new ApiKeyCounter();

        private ApyKeyCounterHolder() {
        }
    }
}

