/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.ApiKeyCounter;
import io.split.client.HttpSegmentChangeFetcher;
import io.split.client.HttpSplitChangeFetcher;
import io.split.client.SplitClient;
import io.split.client.SplitClientConfig;
import io.split.client.SplitClientImpl;
import io.split.client.SplitFactory;
import io.split.client.SplitManager;
import io.split.client.SplitManagerImpl;
import io.split.client.dtos.Metadata;
import io.split.client.events.EventsTask;
import io.split.client.events.InMemoryEventsStorage;
import io.split.client.impressions.AsynchronousImpressionListener;
import io.split.client.impressions.ImpressionListener;
import io.split.client.impressions.ImpressionsManagerImpl;
import io.split.client.impressions.ImpressionsStorageConsumer;
import io.split.client.impressions.ImpressionsStorageProducer;
import io.split.client.impressions.InMemoryImpressionsStorage;
import io.split.client.interceptors.AuthorizationInterceptorFilter;
import io.split.client.interceptors.ClientKeyInterceptorFilter;
import io.split.client.interceptors.GzipDecoderResponseInterceptor;
import io.split.client.interceptors.GzipEncoderRequestInterceptor;
import io.split.client.interceptors.SdkMetadataInterceptorFilter;
import io.split.client.utils.SDKMetadata;
import io.split.engine.SDKReadinessGates;
import io.split.engine.common.SyncManager;
import io.split.engine.common.SyncManagerImp;
import io.split.engine.evaluator.Evaluator;
import io.split.engine.evaluator.EvaluatorImp;
import io.split.engine.experiments.SplitFetcher;
import io.split.engine.experiments.SplitFetcherImp;
import io.split.engine.experiments.SplitParser;
import io.split.engine.experiments.SplitSynchronizationTask;
import io.split.engine.segments.SegmentSynchronizationTaskImp;
import io.split.integrations.IntegrationsConfig;
import io.split.storages.SegmentCacheConsumer;
import io.split.storages.SegmentCacheProducer;
import io.split.storages.SplitCacheConsumer;
import io.split.storages.SplitCacheProducer;
import io.split.storages.enums.OperationMode;
import io.split.storages.memory.InMemoryCacheImp;
import io.split.storages.memory.SegmentCacheInMemoryImpl;
import io.split.storages.pluggable.adapters.UserCustomEventAdapterProducer;
import io.split.storages.pluggable.adapters.UserCustomImpressionAdapterConsumer;
import io.split.storages.pluggable.adapters.UserCustomImpressionAdapterProducer;
import io.split.storages.pluggable.adapters.UserCustomSegmentAdapterConsumer;
import io.split.storages.pluggable.adapters.UserCustomSplitAdapterConsumer;
import io.split.storages.pluggable.adapters.UserCustomTelemetryAdapterProducer;
import io.split.storages.pluggable.domain.SafeUserStorageWrapper;
import io.split.storages.pluggable.synchronizer.TelemetryConsumerSubmitter;
import io.split.telemetry.storage.InMemoryTelemetryStorage;
import io.split.telemetry.storage.TelemetryStorageProducer;
import io.split.telemetry.synchronizer.TelemetryInMemorySubmitter;
import io.split.telemetry.synchronizer.TelemetrySyncTask;
import io.split.telemetry.synchronizer.TelemetrySynchronizer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluggable.CustomStorageWrapper;
import split.com.google.common.util.concurrent.ThreadFactoryBuilder;

public class SplitFactoryImpl
implements SplitFactory {
    private static final Logger _log = LoggerFactory.getLogger(SplitFactory.class);
    private static final long SSE_CONNECT_TIMEOUT = 30000L;
    private static final long SSE_SOCKET_TIMEOUT = 70000L;
    private static Random RANDOM = new Random();
    private final SDKReadinessGates _gates;
    private final ImpressionsManagerImpl _impressionsManager;
    private final Evaluator _evaluator;
    private final String _apiToken;
    private final SplitClient _client;
    private final SplitManager _manager;
    private final SplitCacheConsumer _splitCache;
    private final SegmentCacheConsumer _segmentCache;
    private boolean isTerminated = false;
    private final ApiKeyCounter _apiKeyCounter;
    private final TelemetryStorageProducer _telemetryStorageProducer;
    private final TelemetrySynchronizer _telemetrySynchronizer;
    private final long _startTime;
    private final SDKMetadata _sdkMetadata;
    private final OperationMode _operationMode;
    private final TelemetrySyncTask _telemetrySyncTask;
    private final SegmentSynchronizationTaskImp _segmentSynchronizationTaskImp;
    private final SplitFetcher _splitFetcher;
    private final SplitSynchronizationTask _splitSynchronizationTask;
    private final EventsTask _eventsTask;
    private final SyncManager _syncManager;
    private final CloseableHttpClient _httpclient;
    private final SafeUserStorageWrapper _safeUserStorageWrapper;
    private final URI _rootTarget;
    private final URI _eventsRootTarget;

    public SplitFactoryImpl(String apiToken, SplitClientConfig config) throws URISyntaxException {
        this._safeUserStorageWrapper = null;
        this._operationMode = config.operationMode();
        this._startTime = System.currentTimeMillis();
        this._apiToken = apiToken;
        this._apiKeyCounter = ApiKeyCounter.getApiKeyCounterInstance();
        this._apiKeyCounter.add(apiToken);
        this._sdkMetadata = this.createSdkMetadata(config.ipAddressEnabled(), SplitClientConfig.splitSdkVersion);
        InMemoryTelemetryStorage telemetryStorage = new InMemoryTelemetryStorage();
        this._telemetryStorageProducer = telemetryStorage;
        if (config.blockUntilReady() == -1) {
            _log.warn("no setBlockUntilReadyTimeout parameter has been set - incorrect control treatments could be logged\u201d if no ready config has been set when building factory");
        }
        this._gates = new SDKReadinessGates();
        this._httpclient = SplitFactoryImpl.buildHttpClient(apiToken, config, this._sdkMetadata);
        this._rootTarget = URI.create(config.endpoint());
        this._eventsRootTarget = URI.create(config.eventsEndpoint());
        SegmentCacheInMemoryImpl segmentCache = new SegmentCacheInMemoryImpl();
        InMemoryCacheImp splitCache = new InMemoryCacheImp();
        InMemoryImpressionsStorage impressionsStorage = new InMemoryImpressionsStorage(config.impressionsQueueSize());
        this._splitCache = splitCache;
        this._segmentCache = segmentCache;
        this._telemetrySynchronizer = new TelemetryInMemorySubmitter(this._httpclient, URI.create(config.telemetryURL()), telemetryStorage, splitCache, segmentCache, telemetryStorage, this._startTime);
        this._segmentSynchronizationTaskImp = this.buildSegments(config, segmentCache, splitCache);
        this._splitFetcher = this.buildSplitFetcher(splitCache, splitCache);
        this._splitSynchronizationTask = new SplitSynchronizationTask(this._splitFetcher, splitCache, SplitFactoryImpl.findPollingPeriod(RANDOM, config.featuresRefreshRate()));
        this._impressionsManager = this.buildImpressionsManager(config, impressionsStorage, impressionsStorage);
        InMemoryEventsStorage eventsStorage = new InMemoryEventsStorage(config.eventsQueueSize(), this._telemetryStorageProducer);
        this._eventsTask = EventsTask.create(this._httpclient, this._eventsRootTarget, config.eventsQueueSize(), config.eventFlushIntervalInMillis(), config.waitBeforeShutdown(), this._telemetryStorageProducer, eventsStorage, eventsStorage);
        this._telemetrySyncTask = new TelemetrySyncTask(config.get_telemetryRefreshRate(), this._telemetrySynchronizer);
        this._evaluator = new EvaluatorImp(splitCache, segmentCache);
        this._client = new SplitClientImpl(this, splitCache, this._impressionsManager, eventsStorage, config, this._gates, this._evaluator, this._telemetryStorageProducer, this._telemetryStorageProducer);
        this._manager = new SplitManagerImpl(splitCache, config, this._gates, this._telemetryStorageProducer);
        this._syncManager = SyncManagerImp.build(config.streamingEnabled(), this._splitSynchronizationTask, this._splitFetcher, this._segmentSynchronizationTaskImp, splitCache, config.authServiceURL(), this._httpclient, config.streamingServiceURL(), config.authRetryBackoffBase(), SplitFactoryImpl.buildSSEdHttpClient(apiToken, config, this._sdkMetadata), segmentCache, config.streamingRetryDelay(), config.streamingFetchMaxRetries(), config.failedAttemptsBeforeLogging(), config.cdnDebugLogging(), this._gates, this._telemetryStorageProducer, this._telemetrySynchronizer, config);
        this._syncManager.start();
        if (config.destroyOnShutDown()) {
            Thread shutdown = new Thread(() -> this.destroy());
            shutdown.setName("split-destroy-worker");
            Runtime.getRuntime().addShutdownHook(shutdown);
        }
    }

    protected SplitFactoryImpl(String apiToken, SplitClientConfig config, CustomStorageWrapper customStorageWrapper) throws URISyntaxException {
        this._telemetrySyncTask = null;
        this._segmentSynchronizationTaskImp = null;
        this._splitFetcher = null;
        this._splitSynchronizationTask = null;
        this._eventsTask = null;
        this._syncManager = null;
        this._httpclient = null;
        this._rootTarget = null;
        this._eventsRootTarget = null;
        Metadata metadata = new Metadata(config.ipAddressEnabled(), SplitClientConfig.splitSdkVersion);
        this._safeUserStorageWrapper = new SafeUserStorageWrapper(customStorageWrapper);
        UserCustomSegmentAdapterConsumer userCustomSegmentAdapterConsumer = new UserCustomSegmentAdapterConsumer(customStorageWrapper);
        UserCustomSplitAdapterConsumer userCustomSplitAdapterConsumer = new UserCustomSplitAdapterConsumer(customStorageWrapper);
        UserCustomImpressionAdapterConsumer userCustomImpressionAdapterConsumer = new UserCustomImpressionAdapterConsumer();
        UserCustomImpressionAdapterProducer userCustomImpressionAdapterProducer = new UserCustomImpressionAdapterProducer(customStorageWrapper, metadata);
        UserCustomEventAdapterProducer userCustomEventAdapterProducer = new UserCustomEventAdapterProducer(customStorageWrapper, metadata);
        this._operationMode = config.operationMode();
        this._sdkMetadata = this.createSdkMetadata(config.ipAddressEnabled(), SplitClientConfig.splitSdkVersion);
        this._startTime = System.currentTimeMillis();
        this._apiToken = apiToken;
        this._apiKeyCounter = ApiKeyCounter.getApiKeyCounterInstance();
        this._apiKeyCounter.add(apiToken);
        this._telemetryStorageProducer = new UserCustomTelemetryAdapterProducer(customStorageWrapper, this._sdkMetadata);
        this._splitCache = userCustomSplitAdapterConsumer;
        this._segmentCache = userCustomSegmentAdapterConsumer;
        if (config.blockUntilReady() == -1) {
            _log.warn("no setBlockUntilReadyTimeout parameter has been set - incorrect control treatments could be logged\u201d if no ready config has been set when building factory");
        }
        this._gates = new SDKReadinessGates();
        this._evaluator = new EvaluatorImp(userCustomSplitAdapterConsumer, userCustomSegmentAdapterConsumer);
        this._impressionsManager = this.buildImpressionsManager(config, userCustomImpressionAdapterConsumer, userCustomImpressionAdapterProducer);
        this._telemetrySynchronizer = new TelemetryConsumerSubmitter(customStorageWrapper, this._sdkMetadata);
        this._client = new SplitClientImpl(this, userCustomSplitAdapterConsumer, this._impressionsManager, userCustomEventAdapterProducer, config, this._gates, this._evaluator, this._telemetryStorageProducer, this._telemetryStorageProducer);
        this._manager = new SplitManagerImpl(userCustomSplitAdapterConsumer, config, this._gates, this._telemetryStorageProducer);
        this.manageSdkReady(config);
    }

    @Override
    public SplitClient client() {
        return this._client;
    }

    @Override
    public SplitManager manager() {
        return this._manager;
    }

    @Override
    public synchronized void destroy() {
        if (this.isTerminated) {
            return;
        }
        if (OperationMode.STANDALONE.equals((Object)this._operationMode)) {
            _log.info("Shutdown called for split");
            try {
                long splitCount = this._splitCache.getAll().stream().count();
                long segmentCount = this._segmentCache.getSegmentCount();
                long segmentKeyCount = this._segmentCache.getKeyCount();
                this._impressionsManager.close();
                _log.info("Successful shutdown of impressions manager");
                this._eventsTask.close();
                _log.info("Successful shutdown of eventsTask");
                this._segmentSynchronizationTaskImp.close();
                _log.info("Successful shutdown of segment fetchers");
                this._splitSynchronizationTask.close();
                _log.info("Successful shutdown of splits");
                this._syncManager.shutdown();
                _log.info("Successful shutdown of syncManager");
                this._telemetryStorageProducer.recordSessionLength(System.currentTimeMillis() - this._startTime);
                this._telemetrySyncTask.stopScheduledTask(splitCount, segmentCount, segmentKeyCount);
                _log.info("Successful shutdown of telemetry sync task");
                this._httpclient.close();
                _log.info("Successful shutdown of httpclient");
            }
            catch (IOException e) {
                _log.error("We could not shutdown split", (Throwable)e);
            }
        } else if (OperationMode.CONSUMER.equals((Object)this._operationMode)) {
            this._safeUserStorageWrapper.disconnect();
        }
        this._apiKeyCounter.remove(this._apiToken);
        this.isTerminated = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.isTerminated;
    }

    private static CloseableHttpClient buildHttpClient(String apiToken, SplitClientConfig config, SDKMetadata sdkMetadata) {
        SSLConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactoryBuilder.create().setSslContext(SSLContexts.createSystemDefault()).setTlsVersions(TLS.V_1_1, TLS.V_1_2).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds(config.connectionTimeout())).setCookieSpec("strict").build();
        PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory(sslSocketFactory).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.ofMilliseconds(config.readTimeout())).build()).setValidateAfterInactivity(TimeValue.ofMilliseconds(config.validateAfterInactivityInMillis())).build();
        cm.setMaxTotal(20);
        cm.setDefaultMaxPerRoute(20);
        HttpClientBuilder httpClientbuilder = HttpClients.custom().setConnectionManager(cm).setDefaultRequestConfig(requestConfig).addRequestInterceptorLast(AuthorizationInterceptorFilter.instance(apiToken)).addRequestInterceptorLast(SdkMetadataInterceptorFilter.instance(sdkMetadata)).addRequestInterceptorLast(new GzipEncoderRequestInterceptor()).addResponseInterceptorLast(new GzipDecoderResponseInterceptor());
        if (config.proxy() != null) {
            httpClientbuilder = SplitFactoryImpl.setupProxy(httpClientbuilder, config);
        }
        return httpClientbuilder.build();
    }

    private static CloseableHttpClient buildSSEdHttpClient(String apiToken, SplitClientConfig config, SDKMetadata sdkMetadata) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds(30000L)).build();
        SSLConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactoryBuilder.create().setSslContext(SSLContexts.createSystemDefault()).setTlsVersions(TLS.V_1_1, TLS.V_1_2).build();
        PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory(sslSocketFactory).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.ofMilliseconds(70000L)).build()).build();
        cm.setMaxTotal(1);
        cm.setDefaultMaxPerRoute(1);
        HttpClientBuilder httpClientbuilder = HttpClients.custom().setConnectionManager(cm).setDefaultRequestConfig(requestConfig).addRequestInterceptorLast(SdkMetadataInterceptorFilter.instance(sdkMetadata)).addRequestInterceptorLast(ClientKeyInterceptorFilter.instance(apiToken));
        if (config.proxy() != null) {
            httpClientbuilder = SplitFactoryImpl.setupProxy(httpClientbuilder, config);
        }
        return httpClientbuilder.build();
    }

    private static HttpClientBuilder setupProxy(HttpClientBuilder httpClientbuilder, SplitClientConfig config) {
        _log.info("Initializing Split SDK with proxy settings");
        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(config.proxy());
        httpClientbuilder.setRoutePlanner(routePlanner);
        if (config.proxyUsername() != null && config.proxyPassword() != null) {
            _log.debug("Proxy setup using credentials");
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            AuthScope siteScope = new AuthScope(config.proxy().getHostName(), config.proxy().getPort());
            UsernamePasswordCredentials siteCreds = new UsernamePasswordCredentials(config.proxyUsername(), config.proxyPassword().toCharArray());
            credsProvider.setCredentials(siteScope, siteCreds);
            httpClientbuilder.setDefaultCredentialsProvider(credsProvider);
        }
        return httpClientbuilder;
    }

    private static int findPollingPeriod(Random rand, int max) {
        int min2 = max / 2;
        return rand.nextInt(max - min2 + 1) + min2;
    }

    private SegmentSynchronizationTaskImp buildSegments(SplitClientConfig config, SegmentCacheProducer segmentCacheProducer, SplitCacheConsumer splitCacheConsumer) throws URISyntaxException {
        HttpSegmentChangeFetcher segmentChangeFetcher = HttpSegmentChangeFetcher.create(this._httpclient, this._rootTarget, this._telemetryStorageProducer);
        return new SegmentSynchronizationTaskImp(segmentChangeFetcher, SplitFactoryImpl.findPollingPeriod(RANDOM, config.segmentsRefreshRate()), config.numThreadsForSegmentFetch(), this._gates, segmentCacheProducer, this._telemetryStorageProducer, splitCacheConsumer);
    }

    private SplitFetcher buildSplitFetcher(SplitCacheConsumer splitCacheConsumer, SplitCacheProducer splitCacheProducer) throws URISyntaxException {
        HttpSplitChangeFetcher splitChangeFetcher = HttpSplitChangeFetcher.create(this._httpclient, this._rootTarget, this._telemetryStorageProducer);
        SplitParser splitParser = new SplitParser();
        return new SplitFetcherImp(splitChangeFetcher, splitParser, splitCacheConsumer, splitCacheProducer, this._telemetryStorageProducer);
    }

    private ImpressionsManagerImpl buildImpressionsManager(SplitClientConfig config, ImpressionsStorageConsumer impressionsStorageConsumer, ImpressionsStorageProducer impressionsStorageProducer) throws URISyntaxException {
        ArrayList<ImpressionListener> impressionListeners = new ArrayList<ImpressionListener>();
        if (config.integrationsConfig() != null) {
            config.integrationsConfig().getImpressionsListeners(IntegrationsConfig.Execution.ASYNC).stream().map(l -> AsynchronousImpressionListener.build(l.listener(), l.queueSize())).collect(Collectors.toCollection(() -> impressionListeners));
            config.integrationsConfig().getImpressionsListeners(IntegrationsConfig.Execution.SYNC).stream().map(IntegrationsConfig.ImpressionListenerWithMeta::listener).collect(Collectors.toCollection(() -> impressionListeners));
        }
        return ImpressionsManagerImpl.instance(this._httpclient, config, impressionListeners, this._telemetryStorageProducer, impressionsStorageConsumer, impressionsStorageProducer);
    }

    private SDKMetadata createSdkMetadata(boolean ipAddressEnabled, String splitSdkVersion) {
        String machineName = "";
        String ip = "";
        if (ipAddressEnabled) {
            try {
                InetAddress localHost = InetAddress.getLocalHost();
                machineName = localHost.getHostName();
                ip = localHost.getHostAddress();
            }
            catch (Exception e) {
                _log.error("Could not resolve InetAddress", (Throwable)e);
            }
        }
        return new SDKMetadata(splitSdkVersion, ip, machineName);
    }

    private void manageSdkReady(SplitClientConfig config) {
        ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("SPLIT-SDKReadyForConsumer-%d").setDaemon(true).build());
        executorService.submit(() -> {
            while (!this._safeUserStorageWrapper.connect()) {
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    _log.warn("Sdk Initializer thread interrupted");
                    Thread.currentThread().interrupt();
                }
            }
            this._gates.sdkInternalReady();
            this._telemetrySynchronizer.synchronizeConfig(config, System.currentTimeMillis(), ApiKeyCounter.getApiKeyCounterInstance().getFactoryInstances(), new ArrayList<String>());
        });
    }
}

