/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.SplitClient;
import io.split.client.SplitClientConfig;
import io.split.client.SplitFactory;
import io.split.client.api.Key;
import io.split.client.api.SplitResult;
import io.split.client.dtos.Event;
import io.split.client.events.EventsStorageProducer;
import io.split.client.impressions.Impression;
import io.split.client.impressions.ImpressionsManager;
import io.split.engine.SDKReadinessGates;
import io.split.engine.evaluator.Evaluator;
import io.split.engine.evaluator.EvaluatorImp;
import io.split.inputValidation.EventsValidator;
import io.split.inputValidation.KeyValidator;
import io.split.inputValidation.SplitNameValidator;
import io.split.inputValidation.TrafficTypeValidator;
import io.split.storages.SplitCacheConsumer;
import io.split.telemetry.domain.enums.MethodEnum;
import io.split.telemetry.storage.TelemetryConfigProducer;
import io.split.telemetry.storage.TelemetryEvaluationProducer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;

public final class SplitClientImpl
implements SplitClient {
    public static final SplitResult SPLIT_RESULT_CONTROL = new SplitResult("control", null);
    private static final Logger _log = LoggerFactory.getLogger(SplitClientImpl.class);
    private final SplitFactory _container;
    private final SplitCacheConsumer _splitCacheConsumer;
    private final ImpressionsManager _impressionManager;
    private final SplitClientConfig _config;
    private final EventsStorageProducer _eventsStorageProducer;
    private final SDKReadinessGates _gates;
    private final Evaluator _evaluator;
    private final TelemetryEvaluationProducer _telemetryEvaluationProducer;
    private final TelemetryConfigProducer _telemetryConfigProducer;

    public SplitClientImpl(SplitFactory container, SplitCacheConsumer splitCacheConsumer, ImpressionsManager impressionManager, EventsStorageProducer eventsStorageProducer, SplitClientConfig config, SDKReadinessGates gates, Evaluator evaluator, TelemetryEvaluationProducer telemetryEvaluationProducer, TelemetryConfigProducer telemetryConfigProducer) {
        this._container = container;
        this._splitCacheConsumer = Preconditions.checkNotNull(splitCacheConsumer);
        this._impressionManager = Preconditions.checkNotNull(impressionManager);
        this._eventsStorageProducer = eventsStorageProducer;
        this._config = config;
        this._gates = Preconditions.checkNotNull(gates);
        this._evaluator = Preconditions.checkNotNull(evaluator);
        this._telemetryEvaluationProducer = Preconditions.checkNotNull(telemetryEvaluationProducer);
        this._telemetryConfigProducer = Preconditions.checkNotNull(telemetryConfigProducer);
    }

    @Override
    public String getTreatment(String key, String split) {
        return this.getTreatment(key, split, Collections.emptyMap());
    }

    @Override
    public String getTreatment(String key, String split, Map<String, Object> attributes) {
        return this.getTreatmentWithConfigInternal(key, null, split, attributes, MethodEnum.TREATMENT).treatment();
    }

    @Override
    public String getTreatment(Key key, String split, Map<String, Object> attributes) {
        return this.getTreatmentWithConfigInternal(key.matchingKey(), key.bucketingKey(), split, attributes, MethodEnum.TREATMENT).treatment();
    }

    @Override
    public SplitResult getTreatmentWithConfig(String key, String split) {
        return this.getTreatmentWithConfigInternal(key, null, split, Collections.emptyMap(), MethodEnum.TREATMENT_WITH_CONFIG);
    }

    @Override
    public SplitResult getTreatmentWithConfig(String key, String split, Map<String, Object> attributes) {
        return this.getTreatmentWithConfigInternal(key, null, split, attributes, MethodEnum.TREATMENT_WITH_CONFIG);
    }

    @Override
    public SplitResult getTreatmentWithConfig(Key key, String split, Map<String, Object> attributes) {
        return this.getTreatmentWithConfigInternal(key.matchingKey(), key.bucketingKey(), split, attributes, MethodEnum.TREATMENT_WITH_CONFIG);
    }

    @Override
    public Map<String, String> getTreatments(String key, List<String> splits) {
        return this.getTreatments(key, splits, Collections.emptyMap());
    }

    @Override
    public Map<String, String> getTreatments(String key, List<String> splits, Map<String, Object> attributes) {
        return this.getTreatmentsWithConfigInternal(key, null, splits, attributes, MethodEnum.TREATMENTS).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SplitResult)e.getValue()).treatment()));
    }

    @Override
    public Map<String, String> getTreatments(Key key, List<String> splits, Map<String, Object> attributes) {
        return this.getTreatmentsWithConfigInternal(key.matchingKey(), key.bucketingKey(), splits, attributes, MethodEnum.TREATMENTS).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SplitResult)e.getValue()).treatment()));
    }

    @Override
    public Map<String, SplitResult> getTreatmentsWithConfig(String key, List<String> splits) {
        return this.getTreatmentsWithConfigInternal(key, null, splits, Collections.emptyMap(), MethodEnum.TREATMENTS_WITH_CONFIG);
    }

    @Override
    public Map<String, SplitResult> getTreatmentsWithConfig(String key, List<String> splits, Map<String, Object> attributes) {
        return this.getTreatmentsWithConfigInternal(key, null, splits, attributes, MethodEnum.TREATMENTS_WITH_CONFIG);
    }

    @Override
    public Map<String, SplitResult> getTreatmentsWithConfig(Key key, List<String> splits, Map<String, Object> attributes) {
        return this.getTreatmentsWithConfigInternal(key.matchingKey(), key.bucketingKey(), splits, attributes, MethodEnum.TREATMENTS_WITH_CONFIG);
    }

    @Override
    public boolean track(String key, String trafficType, String eventType) {
        Event event = this.createEvent(key, trafficType, eventType);
        return this.track(event);
    }

    @Override
    public boolean track(String key, String trafficType, String eventType, double value) {
        Event event = this.createEvent(key, trafficType, eventType);
        event.value = value;
        return this.track(event);
    }

    @Override
    public boolean track(String key, String trafficType, String eventType, Map<String, Object> properties) {
        Event event = this.createEvent(key, trafficType, eventType);
        event.properties = new HashMap<String, Object>(properties);
        return this.track(event);
    }

    @Override
    public boolean track(String key, String trafficType, String eventType, double value, Map<String, Object> properties) {
        Event event = this.createEvent(key, trafficType, eventType);
        event.properties = new HashMap<String, Object>(properties);
        event.value = value;
        return this.track(event);
    }

    @Override
    public void blockUntilReady() throws TimeoutException, InterruptedException {
        long startTime = System.currentTimeMillis();
        if (this._config.blockUntilReady() <= 0) {
            throw new IllegalArgumentException("setBlockUntilReadyTimeout must be positive but in config was: " + this._config.blockUntilReady());
        }
        if (!this._gates.waitUntilInternalReady(this._config.blockUntilReady())) {
            throw new TimeoutException("SDK was not ready in " + this._config.blockUntilReady() + " milliseconds");
        }
        _log.debug(String.format("Split SDK ready in %d ms", System.currentTimeMillis() - startTime));
    }

    @Override
    public void destroy() {
        this._container.destroy();
    }

    private boolean track(Event event) {
        long initTime = System.currentTimeMillis();
        if (this._container.isDestroyed()) {
            _log.error("Client has already been destroyed - no calls possible");
            return false;
        }
        Optional<String> trafficTypeResult = TrafficTypeValidator.isValid(event.trafficTypeName, this._splitCacheConsumer, "track");
        if (!trafficTypeResult.isPresent()) {
            return false;
        }
        event.trafficTypeName = trafficTypeResult.get();
        if (!EventsValidator.typeIsValid(event.eventTypeId, "track")) {
            return false;
        }
        if (!KeyValidator.isValid(event.key, "key", this._config.maxStringLength(), "track")) {
            return false;
        }
        EventsValidator.EventValidatorResult propertiesResult = EventsValidator.propertiesAreValid(event.properties);
        if (!propertiesResult.getSuccess()) {
            return false;
        }
        event.properties = propertiesResult.getValue();
        this._telemetryEvaluationProducer.recordLatency(MethodEnum.TRACK, System.currentTimeMillis() - initTime);
        return this._eventsStorageProducer.track(event, propertiesResult.getEventSize());
    }

    private SplitResult getTreatmentWithConfigInternal(String matchingKey, String bucketingKey, String split, Map<String, Object> attributes, MethodEnum methodEnum) {
        long initTime = System.currentTimeMillis();
        try {
            this.checkSDKReady(methodEnum);
            if (this._container.isDestroyed()) {
                _log.error("Client has already been destroyed - no calls possible");
                return SPLIT_RESULT_CONTROL;
            }
            if (!KeyValidator.isValid(matchingKey, "matchingKey", this._config.maxStringLength(), methodEnum.getMethod())) {
                return SPLIT_RESULT_CONTROL;
            }
            if (!KeyValidator.bucketingKeyIsValid(bucketingKey, this._config.maxStringLength(), methodEnum.getMethod())) {
                return SPLIT_RESULT_CONTROL;
            }
            Optional<String> splitNameResult = SplitNameValidator.isValid(split, methodEnum.getMethod());
            if (!splitNameResult.isPresent()) {
                return SPLIT_RESULT_CONTROL;
            }
            split = splitNameResult.get();
            long start = System.currentTimeMillis();
            EvaluatorImp.TreatmentLabelAndChangeNumber result = this._evaluator.evaluateFeature(matchingKey, bucketingKey, split, attributes);
            if (result.treatment.equals("control") && result.label.equals("definition not found") && this._gates.isSDKReady()) {
                _log.warn("%s: you passed \"" + split + "\" that does not exist in this environment, please double check what Splits exist in the web console.", (Object)methodEnum.getMethod());
                return SPLIT_RESULT_CONTROL;
            }
            this.recordStats(matchingKey, bucketingKey, split, start, result.treatment, String.format("sdk.%s", methodEnum.getMethod()), this._config.labelsEnabled() ? result.label : null, result.changeNumber, attributes);
            this._telemetryEvaluationProducer.recordLatency(methodEnum, System.currentTimeMillis() - initTime);
            return new SplitResult(result.treatment, result.configurations);
        }
        catch (Exception e) {
            try {
                this._telemetryEvaluationProducer.recordException(methodEnum);
                _log.error("CatchAll Exception", (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return SPLIT_RESULT_CONTROL;
        }
    }

    private Map<String, SplitResult> getTreatmentsWithConfigInternal(String matchingKey, String bucketingKey, List<String> splits, Map<String, Object> attributes, MethodEnum methodEnum) {
        long initTime = System.currentTimeMillis();
        if (splits == null) {
            _log.error("%s: split_names must be a non-empty array", (Object)methodEnum.getMethod());
            return new HashMap<String, SplitResult>();
        }
        try {
            this.checkSDKReady(methodEnum);
            if (this._container.isDestroyed()) {
                _log.error("Client has already been destroyed - no calls possible");
                return this.createMapControl(splits);
            }
            if (!KeyValidator.isValid(matchingKey, "matchingKey", this._config.maxStringLength(), methodEnum.getMethod())) {
                return this.createMapControl(splits);
            }
            if (!KeyValidator.bucketingKeyIsValid(bucketingKey, this._config.maxStringLength(), methodEnum.getMethod())) {
                return this.createMapControl(splits);
            }
            if (splits.isEmpty()) {
                _log.error("%s: split_names must be a non-empty array", (Object)methodEnum.getMethod());
                return new HashMap<String, SplitResult>();
            }
            splits = SplitNameValidator.areValid(splits, methodEnum.getMethod());
            Map<String, EvaluatorImp.TreatmentLabelAndChangeNumber> evaluatorResult = this._evaluator.evaluateFeatures(matchingKey, bucketingKey, splits, attributes);
            ArrayList<Impression> impressions = new ArrayList<Impression>();
            HashMap<String, SplitResult> result = new HashMap<String, SplitResult>();
            evaluatorResult.keySet().forEach(t -> {
                if (((EvaluatorImp.TreatmentLabelAndChangeNumber)evaluatorResult.get((Object)t)).treatment.equals("control") && ((EvaluatorImp.TreatmentLabelAndChangeNumber)evaluatorResult.get((Object)t)).label.equals("definition not found") && this._gates.isSDKReady()) {
                    _log.warn("%s: you passed \"" + t + "\" that does not exist in this environment, please double check what Splits exist in the web console.", (Object)methodEnum.getMethod());
                    result.put((String)t, SPLIT_RESULT_CONTROL);
                } else {
                    result.put((String)t, new SplitResult(((EvaluatorImp.TreatmentLabelAndChangeNumber)evaluatorResult.get((Object)t)).treatment, ((EvaluatorImp.TreatmentLabelAndChangeNumber)evaluatorResult.get((Object)t)).configurations));
                    impressions.add(new Impression(matchingKey, bucketingKey, (String)t, ((EvaluatorImp.TreatmentLabelAndChangeNumber)evaluatorResult.get((Object)t)).treatment, System.currentTimeMillis(), ((EvaluatorImp.TreatmentLabelAndChangeNumber)evaluatorResult.get((Object)t)).label, ((EvaluatorImp.TreatmentLabelAndChangeNumber)evaluatorResult.get((Object)t)).changeNumber, attributes));
                }
            });
            this._telemetryEvaluationProducer.recordLatency(methodEnum, System.currentTimeMillis() - initTime);
            if (impressions.size() > 0) {
                this._impressionManager.track(impressions);
            }
            return result;
        }
        catch (Exception e) {
            try {
                this._telemetryEvaluationProducer.recordException(methodEnum);
                _log.error("CatchAll Exception", (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.createMapControl(splits);
        }
    }

    private void recordStats(String matchingKey, String bucketingKey, String split, long start, String result, String operation, String label, Long changeNumber, Map<String, Object> attributes) {
        try {
            this._impressionManager.track(Stream.of(new Impression(matchingKey, bucketingKey, split, result, System.currentTimeMillis(), label, changeNumber, attributes)).collect(Collectors.toList()));
        }
        catch (Throwable t) {
            _log.error("Exception", t);
        }
    }

    private Event createEvent(String key, String trafficType, String eventType) {
        Event event = new Event();
        event.eventTypeId = eventType;
        event.trafficTypeName = trafficType;
        event.key = key;
        event.timestamp = System.currentTimeMillis();
        return event;
    }

    private void checkSDKReady(MethodEnum methodEnum) {
        if (!this._gates.isSDKReady()) {
            _log.warn(methodEnum.getMethod() + ": the SDK is not ready, results may be incorrect. Make sure to wait for SDK readiness before using this method");
            this._telemetryConfigProducer.recordNonReadyUsage();
        }
    }

    private Map<String, SplitResult> createMapControl(List<String> splits) {
        HashMap<String, SplitResult> result = new HashMap<String, SplitResult>();
        splits.forEach(s2 -> result.put((String)s2, SPLIT_RESULT_CONTROL));
        return result;
    }
}

