/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.LocalhostSplit;
import io.split.client.SplitAndKey;
import io.split.client.SplitManager;
import io.split.client.api.SplitView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import split.com.google.common.base.Preconditions;
import split.com.google.common.collect.Lists;
import split.com.google.common.collect.Maps;
import split.com.google.common.collect.Sets;

public final class LocalhostSplitManager
implements SplitManager {
    private Map<SplitAndKey, LocalhostSplit> _splitAndKeyToTreatmentMap;
    private Map<String, Set<String>> _splitToTreatmentsMap;

    public static LocalhostSplitManager of(Map<SplitAndKey, LocalhostSplit> featureToTreatmentMap) {
        Preconditions.checkNotNull(featureToTreatmentMap, "featureToTreatmentMap must not be null");
        return new LocalhostSplitManager(featureToTreatmentMap, LocalhostSplitManager.splitsToTreatments(featureToTreatmentMap));
    }

    private static Map<String, Set<String>> splitsToTreatments(Map<SplitAndKey, LocalhostSplit> splitAndKeyStringMap) {
        HashMap<String, Set<String>> splitsToTreatments = Maps.newHashMap();
        for (Map.Entry<SplitAndKey, LocalhostSplit> entry : splitAndKeyStringMap.entrySet()) {
            String split = entry.getKey().split();
            if (!splitsToTreatments.containsKey(split)) {
                splitsToTreatments.put(split, Sets.newHashSet());
            }
            Set treatments = (Set)splitsToTreatments.get(split);
            treatments.add(entry.getValue().treatment);
        }
        return splitsToTreatments;
    }

    private LocalhostSplitManager(Map<SplitAndKey, LocalhostSplit> featureToTreatmentMap, Map<String, Set<String>> splitToTreatmentsMap) {
        Preconditions.checkNotNull(featureToTreatmentMap, "featureToTreatmentMap must not be null");
        this._splitAndKeyToTreatmentMap = featureToTreatmentMap;
        this._splitToTreatmentsMap = splitToTreatmentsMap;
    }

    @Override
    public List<SplitView> splits() {
        ArrayList<SplitView> result = new ArrayList<SplitView>();
        for (Map.Entry<String, Set<String>> entry : this._splitToTreatmentsMap.entrySet()) {
            result.add(this.toSplitView(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    @Override
    public List<String> splitNames() {
        HashSet<String> splits = Sets.newHashSet();
        for (Map.Entry<SplitAndKey, LocalhostSplit> entry : this._splitAndKeyToTreatmentMap.entrySet()) {
            splits.add(entry.getKey().split());
        }
        return Lists.newArrayList(splits);
    }

    @Override
    public void blockUntilReady() throws TimeoutException, InterruptedException {
    }

    @Override
    public SplitView split(String featureName) {
        if (!this._splitToTreatmentsMap.containsKey(featureName)) {
            return null;
        }
        return this.toSplitView(featureName, this._splitToTreatmentsMap.get(featureName));
    }

    void updateFeatureToTreatmentMap(Map<SplitAndKey, LocalhostSplit> featureToTreatmentMap) {
        Preconditions.checkNotNull(featureToTreatmentMap, "featureToTreatmentMap must not be null");
        this._splitAndKeyToTreatmentMap = featureToTreatmentMap;
        this._splitToTreatmentsMap = LocalhostSplitManager.splitsToTreatments(this._splitAndKeyToTreatmentMap);
    }

    private SplitView toSplitView(String featureName, Set<String> treatments) {
        SplitView view = new SplitView();
        view.name = featureName;
        view.killed = false;
        view.trafficType = null;
        view.changeNumber = 0L;
        view.treatments = new ArrayList<String>();
        if (treatments != null) {
            view.treatments.addAll(treatments);
        }
        return view;
    }
}

