/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.sse.client;

import java.io.BufferedReader;
import java.io.StringReader;

public class RawEvent {
    private static final String FIELD_ID = "id";
    private static final String FIELD_EVENT = "event";
    private static final String FIELD_DATA = "data";
    private static final String FIELD_CLIENT_ID = "clientId";
    private static final String KV_DELIMITER = ":";
    private final String _id;
    private final String _event;
    private final String _data;
    private final String _clientId;

    public String id() {
        return this._id;
    }

    public String event() {
        return this._event;
    }

    public String data() {
        return this._data;
    }

    public String clientId() {
        return this._clientId;
    }

    private RawEvent(String id, String event, String data, String clientId) {
        this._id = id;
        this._event = event;
        this._data = data;
        this._clientId = clientId;
    }

    public static RawEvent fromString(String eventRawData) {
        Builder eventBuilder = new Builder();
        BufferedReader fieldReader = new BufferedReader(new StringReader(eventRawData));
        fieldReader.lines().forEach(line -> {
            String[] parts = line.split(KV_DELIMITER, 2);
            if (parts.length < 2) {
                return;
            }
            switch (parts[0].trim()) {
                case "id": {
                    eventBuilder.id(parts[1].trim());
                    break;
                }
                case "clientId": {
                    eventBuilder.clientId(parts[1].trim());
                    break;
                }
                case "data": {
                    eventBuilder.data(parts[1].trim());
                    break;
                }
                case "event": {
                    eventBuilder.event(parts[1].trim());
                }
            }
        });
        return eventBuilder.build();
    }

    public String toString() {
        return String.format("id=%s,clientId=%s,event=%s,data=%s", this._id, this._clientId, this._event, this._data);
    }

    static class Builder {
        private String _id;
        private String _event;
        private String _data;
        private String _clientId;

        Builder() {
        }

        public Builder id(String i) {
            this._id = i;
            return this;
        }

        public Builder event(String e) {
            this._event = e;
            return this;
        }

        public Builder data(String d) {
            this._data = d;
            return this;
        }

        public Builder clientId(String c) {
            this._clientId = c;
            return this;
        }

        public RawEvent build() {
            return new RawEvent(this._id, this._event, this._data, this._clientId);
        }
    }
}

