/*
 * Decompiled with CFR 0.152.
 */
package io.split.telemetry.synchronizer;

import io.split.client.SplitClientConfig;
import io.split.client.impressions.ImpressionListener;
import io.split.client.impressions.ImpressionsManager;
import io.split.integrations.IntegrationsConfig;
import io.split.integrations.NewRelicListener;
import io.split.storages.SegmentCacheConsumer;
import io.split.storages.SplitCacheConsumer;
import io.split.telemetry.domain.Config;
import io.split.telemetry.domain.Rates;
import io.split.telemetry.domain.Stats;
import io.split.telemetry.domain.URLOverrides;
import io.split.telemetry.domain.enums.EventsDataRecordsEnum;
import io.split.telemetry.domain.enums.ImpressionsDataTypeEnum;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import io.split.telemetry.storage.TelemetryStorageConsumer;
import io.split.telemetry.synchronizer.HttpTelemetryMemorySender;
import io.split.telemetry.synchronizer.TelemetrySynchronizer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.base.Preconditions;
import split.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;

public class TelemetryInMemorySubmitter
implements TelemetrySynchronizer {
    private static final int OPERATION_MODE = 0;
    private static final String STORAGE = "memory";
    private HttpTelemetryMemorySender _httpHttpTelemetryMemorySender;
    private TelemetryStorageConsumer _teleTelemetryStorageConsumer;
    private SplitCacheConsumer _splitCacheConsumer;
    private SegmentCacheConsumer _segmentCacheConsumer;
    private final long _initStartTime;

    public TelemetryInMemorySubmitter(CloseableHttpClient client, URI telemetryRootEndpoint, TelemetryStorageConsumer telemetryStorageConsumer, SplitCacheConsumer splitCacheConsumer, SegmentCacheConsumer segmentCacheConsumer, TelemetryRuntimeProducer telemetryRuntimeProducer, long initStartTime) throws URISyntaxException {
        this._httpHttpTelemetryMemorySender = HttpTelemetryMemorySender.create(client, telemetryRootEndpoint, telemetryRuntimeProducer);
        this._teleTelemetryStorageConsumer = Preconditions.checkNotNull(telemetryStorageConsumer);
        this._splitCacheConsumer = Preconditions.checkNotNull(splitCacheConsumer);
        this._segmentCacheConsumer = Preconditions.checkNotNull(segmentCacheConsumer);
        this._initStartTime = initStartTime;
    }

    @Override
    public void synchronizeConfig(SplitClientConfig config, long readyTimeStamp, Map<String, Long> factoryInstances, List<String> tags) {
        this._httpHttpTelemetryMemorySender.postConfig(this.generateConfig(config, readyTimeStamp, factoryInstances, tags));
    }

    @Override
    public void synchronizeStats() throws Exception {
        this._httpHttpTelemetryMemorySender.postStats(this.generateStats());
    }

    @Override
    public void finalSynchronization(long splitCount, long segmentCount, long segmentKeyCount) throws Exception {
        Stats stats = this.generateStats();
        stats.set_splitCount(splitCount);
        stats.set_segmentCount(segmentCount);
        stats.set_segmentKeyCount(segmentKeyCount);
        this._httpHttpTelemetryMemorySender.postStats(stats);
    }

    @VisibleForTesting
    Stats generateStats() throws Exception {
        Stats stats = new Stats();
        stats.set_lastSynchronization(this._teleTelemetryStorageConsumer.getLastSynchronization());
        stats.set_methodLatencies(this._teleTelemetryStorageConsumer.popLatencies());
        stats.set_methodExceptions(this._teleTelemetryStorageConsumer.popExceptions());
        stats.set_httpErrors(this._teleTelemetryStorageConsumer.popHTTPErrors());
        stats.set_httpLatencies(this._teleTelemetryStorageConsumer.popHTTPLatencies());
        stats.set_tokenRefreshes(this._teleTelemetryStorageConsumer.popTokenRefreshes());
        stats.set_authRejections(this._teleTelemetryStorageConsumer.popAuthRejections());
        stats.set_impressionsQueued(this._teleTelemetryStorageConsumer.getImpressionsStats(ImpressionsDataTypeEnum.IMPRESSIONS_QUEUED));
        stats.set_impressionsDeduped(this._teleTelemetryStorageConsumer.getImpressionsStats(ImpressionsDataTypeEnum.IMPRESSIONS_DEDUPED));
        stats.set_impressionsDropped(this._teleTelemetryStorageConsumer.getImpressionsStats(ImpressionsDataTypeEnum.IMPRESSIONS_DROPPED));
        stats.set_splitCount(this._splitCacheConsumer.getAll().stream().count());
        stats.set_segmentCount(this._segmentCacheConsumer.getSegmentCount());
        stats.set_segmentKeyCount(this._segmentCacheConsumer.getKeyCount());
        stats.set_sessionLengthMs(this._teleTelemetryStorageConsumer.getSessionLength());
        stats.set_eventsQueued(this._teleTelemetryStorageConsumer.getEventStats(EventsDataRecordsEnum.EVENTS_QUEUED));
        stats.set_eventsDropped(this._teleTelemetryStorageConsumer.getEventStats(EventsDataRecordsEnum.EVENTS_DROPPED));
        stats.set_streamingEvents(this._teleTelemetryStorageConsumer.popStreamingEvents());
        stats.set_tags(this._teleTelemetryStorageConsumer.popTags());
        return stats;
    }

    @VisibleForTesting
    Config generateConfig(SplitClientConfig splitClientConfig, long readyTimestamp, Map<String, Long> factoryInstances, List<String> tags) {
        Config config = new Config();
        Rates rates = new Rates();
        URLOverrides urlOverrides = new URLOverrides();
        ArrayList<IntegrationsConfig.ImpressionListenerWithMeta> impressionsListeners = new ArrayList<IntegrationsConfig.ImpressionListenerWithMeta>();
        if (splitClientConfig.integrationsConfig() != null) {
            impressionsListeners.addAll(splitClientConfig.integrationsConfig().getImpressionsListeners(IntegrationsConfig.Execution.ASYNC));
            impressionsListeners.addAll(splitClientConfig.integrationsConfig().getImpressionsListeners(IntegrationsConfig.Execution.SYNC));
        }
        List<String> impressions = this.getImpressions(impressionsListeners);
        rates.set_telemetry(splitClientConfig.get_telemetryRefreshRate());
        rates.set_events(splitClientConfig.eventFlushIntervalInMillis());
        rates.set_impressions(splitClientConfig.impressionsRefreshRate());
        rates.set_segments(splitClientConfig.segmentsRefreshRate());
        rates.set_splits(splitClientConfig.featuresRefreshRate());
        urlOverrides.set_auth(!"https://auth.split.io/api/v2/auth".equals(splitClientConfig.authServiceURL()));
        urlOverrides.set_stream(!"https://streaming.split.io/sse".equals(splitClientConfig.streamingServiceURL()));
        urlOverrides.set_sdk(!"https://sdk.split.io".equals(splitClientConfig.endpoint()));
        urlOverrides.set_events(!"https://events.split.io".equals(splitClientConfig.eventsEndpoint()));
        urlOverrides.set_telemetry(!"https://telemetry.split.io/api/v1".equals(splitClientConfig.telemetryURL()));
        config.set_burTimeouts(this._teleTelemetryStorageConsumer.getBURTimeouts());
        config.set_nonReadyUsages(this._teleTelemetryStorageConsumer.getNonReadyUsages());
        config.set_httpProxyDetected(splitClientConfig.proxy() != null);
        config.set_impressionsMode(this.getImpressionsMode(splitClientConfig));
        config.set_integrations(impressions);
        config.set_impressionsListenerEnabled(impressionsListeners.size() - impressions.size() > 0);
        config.set_operationMode(0);
        config.set_storage(STORAGE);
        config.set_impressionsQueueSize(splitClientConfig.impressionsQueueSize());
        config.set_redundantFactories(this.getRedundantFactories(factoryInstances));
        config.set_eventsQueueSize(splitClientConfig.eventsQueueSize());
        config.set_tags(this.getListMaxSize(tags));
        config.set_activeFactories(factoryInstances.size());
        config.set_timeUntilReady(readyTimestamp - this._initStartTime);
        config.set_rates(rates);
        config.set_urlOverrides(urlOverrides);
        config.set_streamingEnabled(splitClientConfig.streamingEnabled());
        return config;
    }

    private long getRedundantFactories(Map<String, Long> factoryInstances) {
        long count = 0L;
        for (Long l : factoryInstances.values()) {
            count = count + l - 1L;
        }
        return count;
    }

    private int getImpressionsMode(SplitClientConfig config) {
        return ImpressionsManager.Mode.OPTIMIZED.equals((Object)config.impressionsMode()) ? 0 : 1;
    }

    private List<String> getListMaxSize(List<String> list) {
        return list.size() > 10 ? list.subList(0, 10) : list;
    }

    private List<String> getImpressions(List<IntegrationsConfig.ImpressionListenerWithMeta> impressionsListeners) {
        ArrayList<String> impressions = new ArrayList<String>();
        for (IntegrationsConfig.ImpressionListenerWithMeta il : impressionsListeners) {
            ImpressionListener listener = il.listener();
            if (!(listener instanceof NewRelicListener)) continue;
            impressions.add(NewRelicListener.class.getName());
        }
        return impressions;
    }
}

