/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.projectsettings;

import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFile;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ProjectSettingsFileTests {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void fromFileAdaptsFile() throws Exception {
        File file = this.temp.newFile();
        this.writeText(file, "test");
        ProjectSettingsFile projectSettingsFile = ProjectSettingsFile.fromFile((File)file);
        Assertions.assertThat((String)projectSettingsFile.getName()).isEqualTo((Object)file.getName());
        Assertions.assertThat((InputStream)projectSettingsFile.getContent()).hasSameContentAs((InputStream)new ByteArrayInputStream("test".getBytes()));
    }

    @Test
    public void fromClasspathResourceAdaptsResource() throws Exception {
        ProjectSettingsFile projectSettingsFile = ProjectSettingsFile.fromClasspath(this.getClass(), (String)"test.txt");
        Assertions.assertThat((String)projectSettingsFile.getName()).isEqualTo((Object)"test.txt");
        Assertions.assertThat((InputStream)projectSettingsFile.getContent()).hasSameContentAs((InputStream)new ByteArrayInputStream("test".getBytes()));
    }

    private void writeText(File file, String s) throws FileNotFoundException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintWriter writer = new PrintWriter(file);){
            writer.write(s);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

