/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.gradle;

import io.spring.javaformat.eclipse.gradle.RefreshProjectsSettingsJob;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.event.Event;
import org.eclipse.buildship.core.internal.event.EventListener;
import org.eclipse.buildship.core.internal.util.collections.AdapterFunction;
import org.eclipse.buildship.core.internal.workspace.GradleNatureAddedEvent;
import org.eclipse.buildship.core.internal.workspace.ProjectCreatedEvent;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;

public final class RefreshProjectSettingsListeners {
    private RefreshProjectSettingsListeners() {
    }

    public static void attach() {
        try {
            ProjectListener.attach();
            CommandListener.attach();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
    }

    private static class CommandListener
    implements IExecutionListener {
        private static final String COMMAND_NAME = "org.eclipse.buildship.ui.commands.refreshproject";
        private ThreadLocal<ExecutionEvent> event = new ThreadLocal();

        private CommandListener() {
        }

        public void preExecute(String commandId, ExecutionEvent event) {
            this.event.set(event);
        }

        public void postExecuteSuccess(String commandId, Object returnValue) {
            Set<IProject> projects = this.getProjects(this.event.get());
            this.event.set(null);
            new RefreshProjectsSettingsJob(projects).schedule();
        }

        private Set<IProject> getProjects(ExecutionEvent event) {
            if (event == null) {
                return null;
            }
            ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (currentSelection instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)currentSelection;
                return this.collectGradleProjects(selection.toList());
            }
            IEditorInput editorInput = HandlerUtil.getActiveEditorInput((ExecutionEvent)event);
            if (editorInput instanceof FileEditorInput) {
                IFile file = ((FileEditorInput)editorInput).getFile();
                return this.collectGradleProjects(Collections.singleton(file));
            }
            return null;
        }

        private Set<IProject> collectGradleProjects(Collection<?> candidates) {
            LinkedHashSet<IProject> projects = new LinkedHashSet<IProject>(candidates.size());
            AdapterFunction adapter = AdapterFunction.forType(IResource.class);
            for (Object candidate : candidates) {
                IResource resource = (IResource)adapter.apply(candidate);
                if (resource == null) continue;
                projects.add(resource.getProject());
            }
            return projects;
        }

        public void postExecuteFailure(String commandId, ExecutionException exception) {
        }

        public void notHandled(String commandId, NotHandledException exception) {
        }

        static void attach() {
            ICommandService commandService;
            Command command;
            if (PlatformUI.isWorkbenchRunning() && (command = (commandService = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class)).getCommand(COMMAND_NAME)) != null) {
                command.addExecutionListener((IExecutionListener)new CommandListener());
            }
        }
    }

    private static class ProjectListener
    implements EventListener {
        private ProjectListener() {
        }

        public void onEvent(Event event) {
            if (event instanceof ProjectCreatedEvent || event instanceof GradleNatureAddedEvent) {
                new RefreshProjectsSettingsJob().schedule();
            }
        }

        static void attach() {
            CorePlugin.listenerRegistry().addEventListener((EventListener)new ProjectListener());
        }
    }
}

