/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.projectsettings;

import io.spring.javaformat.config.IndentationStyle;
import io.spring.javaformat.config.JavaFormatConfig;
import io.spring.javaformat.eclipse.projectsettings.ProjectProperties;
import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFile;
import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFiles;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProjectSettingsFilesLocator {
    private static final String JDT_CORE_PREFS = "org.eclipse.jdt.core.prefs";
    private static final String[] SOURCE_FOLDERS = new String[]{"eclipse", ".eclipse"};
    private static final String[] DEFAULT_FILES = new String[]{"org.eclipse.jdt.core.prefs", "org.eclipse.jdt.ui.prefs"};
    private final File[] searchFolders;

    public ProjectSettingsFilesLocator(File ... searchFolders) {
        this.searchFolders = searchFolders;
    }

    public ProjectSettingsFilesLocator(Collection<File> searchFolders) {
        this.searchFolders = searchFolders.toArray(new File[0]);
    }

    public ProjectSettingsFiles locateSettingsFiles() throws IOException {
        ProjectProperties projectProperties = new ProjectProperties();
        LinkedHashMap<String, ProjectSettingsFile> files = new LinkedHashMap<String, ProjectSettingsFile>();
        Object[] objectArray = this.searchFolders;
        int n = this.searchFolders.length;
        int n2 = 0;
        while (n2 < n) {
            File searchFolder = objectArray[n2];
            String[] stringArray = SOURCE_FOLDERS;
            int n3 = SOURCE_FOLDERS.length;
            int n4 = 0;
            while (n4 < n3) {
                String sourceFolder = stringArray[n4];
                this.add(projectProperties, files, new File(searchFolder, sourceFolder));
                ++n4;
            }
            ++n2;
        }
        objectArray = DEFAULT_FILES;
        n = DEFAULT_FILES.length;
        n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            this.putIfAbsent(files, this.getDefaultSettingsFile((String)file));
            ++n2;
        }
        return new ProjectSettingsFiles(files.values(), projectProperties);
    }

    private ProjectSettingsFile getDefaultSettingsFile(String file) {
        ProjectSettingsFile settingsFile = ProjectSettingsFile.fromClasspath(this.getClass(), file);
        if (settingsFile.getName().equals(JDT_CORE_PREFS)) {
            settingsFile = settingsFile.withUpdatedContent(this::updateFormatter);
        }
        return settingsFile;
    }

    private String updateFormatter(JavaFormatConfig javaFormatConfig, String content) {
        if (javaFormatConfig.getIndentationStyle() == IndentationStyle.SPACES) {
            return content.replace("org.eclipse.jdt.core.javaFormatter=io.spring.javaformat.eclipse.formatter", "org.eclipse.jdt.core.javaFormatter=io.spring.javaformat.eclipse.formatter.spaces");
        }
        return content;
    }

    private void add(ProjectProperties projectProperties, Map<String, ProjectSettingsFile> files, File folder) throws IOException {
        if (folder.exists() && folder.isDirectory()) {
            File[] fileArray = folder.listFiles(this::isPrefsFile);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.putIfAbsent(files, ProjectSettingsFile.fromFile(file));
                ++n2;
            }
            projectProperties.addFromFolder(folder);
        }
    }

    private boolean isPrefsFile(File file) {
        return file.getName().toLowerCase().endsWith(".prefs");
    }

    private void putIfAbsent(Map<String, ProjectSettingsFile> files, ProjectSettingsFile candidate) {
        files.putIfAbsent(candidate.getName(), candidate);
    }
}

