/*
 * Decompiled with CFR 0.152.
 */
package io.testable.selenium;

import io.testable.selenium.TestableFinishSuite;
import io.testable.selenium.TestableFinishSuiteTest;
import io.testable.selenium.TestableSelenium;
import io.testable.selenium.TestableStartSuite;
import io.testable.selenium.TestableStartSuiteTest;

public class TestableTest {
    private static final boolean IGNORE_SKIPS = Boolean.getBoolean("testable_ignore_skips");
    private final TestableStartSuite startSuite;
    private TestableStartSuiteTest currentTest = null;
    private boolean hasError = false;

    TestableTest(String name) {
        this.startSuite = new TestableStartSuite(name, System.currentTimeMillis());
        TestableTest.write("StartSuite", this.startSuite);
    }

    public void runStep(String name, Runnable step) {
        try {
            this.startStep(name);
            step.run();
            this.finishSuccessfulStep();
        }
        catch (Exception e) {
            this.finishFailedStep(e);
        }
    }

    public void startStep(String name) {
        this.currentTest = new TestableStartSuiteTest(this.startSuite, name, System.currentTimeMillis());
        TestableTest.write("StartSuiteTest", this.currentTest);
    }

    public void finishSuccessfulStep() {
        this.finishStep(TestableFinishSuiteTest.passed(this.currentTest));
    }

    public void finishSkippedStep(String name) {
        boolean hasNotStarted;
        boolean bl = hasNotStarted = this.currentTest == null || !this.currentTest.getName().equals(name);
        if (hasNotStarted && IGNORE_SKIPS) {
            return;
        }
        if (hasNotStarted) {
            this.startStep(name);
        }
        this.finishStep(TestableFinishSuiteTest.skipped(this.currentTest));
    }

    public void finishFailedStep(Throwable t) {
        this.finishStep(TestableFinishSuiteTest.failed(this.currentTest, t));
    }

    public void finishFailedStep(String errorMsg) {
        this.finishStep(TestableFinishSuiteTest.failed(this.currentTest, errorMsg));
    }

    private void finishStep(TestableFinishSuiteTest finishMsg) {
        if (this.currentTest != null) {
            TestableTest.write("FinishSuiteTest", finishMsg);
            if (finishMsg.getError() != null) {
                this.hasError = true;
            }
            this.currentTest = null;
        }
    }

    public void assertionPassed(String assertion, long duration) {
        this.currentTest = new TestableStartSuiteTest(this.startSuite, assertion, System.currentTimeMillis() - duration);
        TestableTest.write("StartSuiteTest", this.currentTest);
        this.finishStep(TestableFinishSuiteTest.passed(this.currentTest));
    }

    public void assertionFailed(String assertion, long duration, Throwable t) {
        this.currentTest = new TestableStartSuiteTest(this.startSuite, assertion, System.currentTimeMillis() - duration);
        TestableTest.write("StartSuiteTest", this.currentTest);
        this.finishStep(TestableFinishSuiteTest.failed(this.currentTest, t));
    }

    public void assertionFailed(String assertion, long duration, String errorMessage) {
        this.currentTest = new TestableStartSuiteTest(this.startSuite, assertion, System.currentTimeMillis() - duration);
        TestableTest.write("StartSuiteTest", this.currentTest);
        this.finishStep(TestableFinishSuiteTest.failed(this.currentTest, errorMessage));
    }

    public void finish() {
        if (this.currentTest != null) {
            TestableTest.write("FinishSuiteTest", TestableFinishSuiteTest.passed(this.currentTest));
        }
        TestableTest.write("FinishSuite", new TestableFinishSuite(this.startSuite, this.hasError));
    }

    private static void write(String type, Object event) {
        TestableSelenium.writeToStream(new TestableSelenium.Result(type, event));
    }
}

