/*
 * Decompiled with CFR 0.152.
 */
package io.testable.selenium;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.http.client.ClientProtocolException;

public class TestableCSVReader {
    private static final int GLOBAL_CLIENT_INDEX = Integer.getInteger("TESTABLE_GLOBAL_CLIENT_INDEX", 0);
    private static final int ITERATION = Integer.getInteger("TESTABLE_ITERATION", 0);
    private static final int CONCURRENT_CLIENTS = Integer.getInteger("TESTABLE_CONCURRENT_CLIENTS", 1);
    private List<CSVRecord> records;
    private int index = CONCURRENT_CLIENTS * ITERATION + GLOBAL_CLIENT_INDEX;

    public TestableCSVReader(String path) throws IOException {
        InputStream fileIs = this.getClass().getClassLoader().getResourceAsStream(path);
        CSVParser parser = CSVParser.parse((InputStream)fileIs, (Charset)StandardCharsets.UTF_8, (CSVFormat)CSVFormat.DEFAULT.withFirstRecordAsHeader());
        this.records = parser.getRecords();
    }

    public CSVRecord get(int index) {
        return this.records.get(index % this.records.size());
    }

    public CSVRecord get(int index, boolean wrap) throws IOException {
        if (!wrap && index >= this.records.size()) {
            throw new ClientProtocolException("End of CSV reached");
        }
        return this.records.get(index % this.records.size());
    }

    public CSVRecord random() {
        int index = (int)Math.floor(Math.random() * (double)this.records.size());
        return this.get(index);
    }

    public CSVRecord next() throws IOException {
        return this.next(true);
    }

    public CSVRecord next(boolean wrap) throws IOException {
        return this.next(1, wrap).get(0);
    }

    public List<CSVRecord> next(int rows) throws IOException {
        return this.next(rows, true);
    }

    public List<CSVRecord> next(int rows, boolean wrap) throws IOException {
        ArrayList<CSVRecord> records = new ArrayList<CSVRecord>(rows);
        for (int i = 0; i < rows; ++i) {
            records.add(this.get(this.index++, wrap));
        }
        return records;
    }
}

