/*
 * Decompiled with CFR 0.152.
 */
package io.trane.future;

import io.trane.future.Future;
import io.trane.future.InterruptHandler;
import io.trane.future.Promise;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

final class CollectPromise<T>
extends Promise<List<T>> {
    private final Object[] results;
    private final AtomicInteger count;
    private final List<? extends Future<T>> list;

    public CollectPromise(List<? extends Future<T>> list) {
        int size = list.size();
        this.results = new Object[size];
        this.count = new AtomicInteger(size);
        this.list = list;
    }

    public final void collect(T value, int i) {
        this.results[i] = value;
        if (this.count.decrementAndGet() == 0) {
            this.setValue(Arrays.asList(this.results));
        }
    }

    @Override
    protected final InterruptHandler getInterruptHandler() {
        return InterruptHandler.apply(this.list);
    }
}

