/*
 * Decompiled with CFR 0.152.
 */
package io.trane.future;

import io.trane.future.CheckedFutureException;
import io.trane.future.Future;
import io.trane.future.NonFatalException;
import io.trane.future.Responder;
import io.trane.future.SatisfiedFuture;
import io.trane.future.Transformer;
import io.trane.future.ValueFuture;
import java.time.Duration;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ExceptionFuture<T>
implements SatisfiedFuture<T> {
    private static final Logger logger = Logger.getLogger(ExceptionFuture.class.getName());
    private final Throwable ex;

    protected ExceptionFuture(Throwable ex) {
        NonFatalException.verify(ex);
        this.ex = ex;
    }

    @Override
    public final <R> Future<R> map(Function<? super T, ? extends R> f) {
        return this.unsafeCast();
    }

    @Override
    public final <R> Future<R> flatMap(Function<? super T, ? extends Future<R>> f) {
        return this.unsafeCast();
    }

    @Override
    public <R> Future<R> transform(Transformer<? super T, ? extends R> t) {
        try {
            return new ValueFuture<R>(t.onException(this.ex));
        }
        catch (Throwable error) {
            return new ExceptionFuture<T>(error);
        }
    }

    @Override
    public <R> Future<R> transformWith(Transformer<? super T, ? extends Future<R>> t) {
        try {
            return t.onException(this.ex);
        }
        catch (Throwable error) {
            return new ExceptionFuture<T>(error);
        }
    }

    @Override
    public <U, R> Future<R> biMap(Future<U> other, BiFunction<? super T, ? super U, ? extends R> f) {
        return this.unsafeCast();
    }

    @Override
    public <U, R> Future<R> biFlatMap(Future<U> other, BiFunction<? super T, ? super U, ? extends Future<R>> f) {
        return this.unsafeCast();
    }

    @Override
    public final Future<T> onSuccess(Consumer<? super T> c) {
        return this;
    }

    @Override
    public final Future<T> onFailure(Consumer<Throwable> c) {
        try {
            c.accept(this.ex);
        }
        catch (Throwable error) {
            logger.log(Level.WARNING, "Error executing `onFailure` callback " + c + "for" + this, this.ex);
            NonFatalException.verify(error);
        }
        return this;
    }

    @Override
    public final Future<T> respond(Responder<? super T> r) {
        try {
            r.onException(this.ex);
        }
        catch (Throwable error) {
            logger.log(Level.WARNING, "Error executing `respond` callback " + r + "for" + this, this.ex);
            NonFatalException.verify(error);
        }
        return this;
    }

    @Override
    public final Future<T> rescue(Function<Throwable, ? extends Future<T>> f) {
        try {
            return f.apply(this.ex);
        }
        catch (Throwable error) {
            return new ExceptionFuture<T>(error);
        }
    }

    @Override
    public final Future<Void> voided() {
        return this.unsafeCast();
    }

    @Override
    public final T get(Duration timeout) throws CheckedFutureException {
        if (this.ex instanceof RuntimeException) {
            throw (RuntimeException)this.ex;
        }
        if (this.ex instanceof Error) {
            throw (Error)this.ex;
        }
        throw new CheckedFutureException(this.ex);
    }

    public final String toString() {
        return String.format("ExceptionFuture(%s)", this.ex);
    }

    public final int hashCode() {
        return this.ex == null ? 0 : this.ex.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExceptionFuture other = (ExceptionFuture)obj;
        return !(this.ex == null ? other.ex != null : !this.ex.equals(other.ex));
    }
}

