/*
 * Decompiled with CFR 0.152.
 */
package io.trane.future;

import io.trane.future.CheckedFutureException;
import io.trane.future.CollectPromise;
import io.trane.future.ExceptionFuture;
import io.trane.future.FirstCompletedOfPromise;
import io.trane.future.FutureConstants;
import io.trane.future.InterruptHandler;
import io.trane.future.JoinPromise;
import io.trane.future.Promise;
import io.trane.future.Responder;
import io.trane.future.SatisfiedFuture;
import io.trane.future.Tailrec;
import io.trane.future.TimeoutException;
import io.trane.future.Transformer;
import io.trane.future.ValueFuture;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Future<T>
extends InterruptHandler {
    public static final Future<Void> VOID = Future.value(null);
    public static final Future<Boolean> FALSE = Future.value(false);
    public static final Future<Boolean> TRUE = Future.value(true);

    public static <T> Future<T> never() {
        return FutureConstants.NEVER.unsafeCast();
    }

    public static <T> Future<T> apply(Supplier<T> s) {
        try {
            return new ValueFuture<T>(s.get());
        }
        catch (Throwable ex) {
            return new ExceptionFuture(ex);
        }
    }

    public static <T> Future<T> flatApply(Supplier<Future<T>> s) {
        try {
            return s.get();
        }
        catch (Throwable ex) {
            return new ExceptionFuture(ex);
        }
    }

    public static <T> Future<T> value(T v) {
        return new ValueFuture<T>(v);
    }

    public static <T> Future<T> exception(Throwable ex) {
        return new ExceptionFuture(ex);
    }

    public static <T> Future<T> flatten(Future<Future<T>> fut) {
        return fut.flatMap(f -> f);
    }

    public static <T> Future<List<T>> emptyList() {
        return FutureConstants.EMPTY_LIST.unsafeCast();
    }

    public static <T> Future<Optional<T>> emptyOptional() {
        return FutureConstants.EMPTY_OPIONAL.unsafeCast();
    }

    public static <T> Future<List<T>> collect(List<? extends Future<T>> list) {
        switch (list.size()) {
            case 0: {
                return Future.emptyList();
            }
            case 1: {
                return list.get(0).map(xva$0 -> Arrays.asList(xva$0));
            }
            case 2: {
                return list.get(0).biMap(list.get(1), (xva$0, xva$1) -> Arrays.asList(xva$0, xva$1));
            }
        }
        final CollectPromise p = new CollectPromise(list);
        int i = 0;
        for (Future<T> f : list) {
            if (f instanceof ExceptionFuture) {
                return f.unsafeCast();
            }
            if (f instanceof ValueFuture) {
                p.collect(((ValueFuture)f).value, i);
            } else {
                final int ii = i;
                Responder responder = new Responder<T>(){

                    @Override
                    public final void onException(Throwable ex) {
                        p.setException(ex);
                    }

                    @Override
                    public final void onValue(T value) {
                        p.collect(value, ii);
                    }
                };
                f.respond(responder);
            }
            ++i;
        }
        return p;
    }

    public static <T> Future<Void> join(List<? extends Future<T>> list) {
        switch (list.size()) {
            case 0: {
                return VOID;
            }
            case 1: {
                return list.get(0).voided();
            }
        }
        JoinPromise p = new JoinPromise(list);
        for (Future f : list) {
            if (f instanceof ExceptionFuture) {
                return f.voided();
            }
            f.respond(p);
        }
        return p;
    }

    public static <T> Future<Integer> selectIndex(List<Future<T>> list) {
        switch (list.size()) {
            case 0: {
                return Future.exception(new IllegalArgumentException("Can't select from empty list."));
            }
            case 1: {
                return list.get(0).map(v -> 0);
            }
        }
        Promise<Integer> p = Promise.apply(list);
        int i = 0;
        for (Future<T> f : list) {
            if (f instanceof SatisfiedFuture) {
                return Future.value(i);
            }
            int ii = i++;
            f.ensure(() -> p.becomeIfEmpty(Future.value(ii)));
        }
        return p;
    }

    public static <T> Future<T> firstCompletedOf(List<Future<T>> list) {
        switch (list.size()) {
            case 0: {
                return Future.exception(new IllegalArgumentException("Can't select first completed future from empty list."));
            }
            case 1: {
                return list.get(0);
            }
        }
        FirstCompletedOfPromise<T> p = new FirstCompletedOfPromise<T>(list);
        for (Future<T> f : list) {
            if (f instanceof SatisfiedFuture) {
                return f;
            }
            f.respond(p);
        }
        return p;
    }

    public static <T> Future<Void> whileDo(Supplier<Boolean> cond, Supplier<Future<T>> f) {
        return Tailrec.apply(() -> {
            if (((Boolean)cond.get()).booleanValue()) {
                return ((Future)f.get()).flatMap(arg_0 -> Future.lambda$null$3((Supplier)cond, (Supplier)f, arg_0));
            }
            return VOID;
        });
    }

    public static Future<Void> delay(Duration delay, ScheduledExecutorService scheduler) {
        return VOID.delayed(delay, scheduler);
    }

    public <R> Future<R> map(Function<? super T, ? extends R> var1);

    public <R> Future<R> flatMap(Function<? super T, ? extends Future<R>> var1);

    public <R> Future<R> transform(Transformer<? super T, ? extends R> var1);

    public <R> Future<R> transformWith(Transformer<? super T, ? extends Future<R>> var1);

    public <U, R> Future<R> biMap(Future<U> var1, BiFunction<? super T, ? super U, ? extends R> var2);

    public <U, R> Future<R> biFlatMap(Future<U> var1, BiFunction<? super T, ? super U, ? extends Future<R>> var2);

    public Future<T> ensure(Runnable var1);

    public Future<T> onSuccess(Consumer<? super T> var1);

    public Future<T> onFailure(Consumer<Throwable> var1);

    public Future<T> respond(Responder<? super T> var1);

    public Future<T> rescue(Function<Throwable, ? extends Future<T>> var1);

    public Future<T> interruptible();

    public boolean isDefined();

    public T get(Duration var1) throws CheckedFutureException;

    public void join(Duration var1) throws CheckedFutureException;

    public Future<Void> voided();

    public Future<T> delayed(Duration var1, ScheduledExecutorService var2);

    public void proxyTo(Promise<T> var1);

    default public Future<T> within(Duration timeout, ScheduledExecutorService scheduler) {
        return this.within(timeout, scheduler, TimeoutException.stackless);
    }

    public Future<T> within(Duration var1, ScheduledExecutorService var2, Throwable var3);

    default public <R> Future<R> unsafeCast() {
        return this;
    }

    private static /* synthetic */ Future lambda$null$3(Supplier supplier, Supplier supplier2, Object r) {
        return Future.whileDo(supplier, supplier2);
    }
}

