/*
 * Decompiled with CFR 0.152.
 */
package io.trane.future;

import io.trane.future.AsyncPromise;
import io.trane.future.Future;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Supplier;

public final class FuturePool {
    private final ExecutorService executor;

    public static FuturePool apply(ExecutorService executor) {
        return new FuturePool(executor);
    }

    private FuturePool(ExecutorService executor) {
        this.executor = executor;
    }

    public final <T> Future<T> isolate(Supplier<Future<T>> s) {
        return Future.flatten(this.async(s));
    }

    public final <T> Future<T> async(Supplier<T> s) {
        try {
            AsyncPromise<T> p = new AsyncPromise<T>(s);
            this.executor.submit(p);
            return p;
        }
        catch (RejectedExecutionException ex) {
            return Future.exception(ex);
        }
    }
}

