/*
 * Decompiled with CFR 0.152.
 */
package io.trane.future;

import io.trane.future.Future;
import io.trane.future.InterruptHandler;
import io.trane.future.Promise;
import io.trane.future.Responder;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

final class JoinPromise<T>
extends Promise<Void>
implements Responder<T> {
    private final AtomicInteger count;
    private final List<? extends Future<T>> list;

    public JoinPromise(List<? extends Future<T>> list) {
        this.list = list;
        this.count = new AtomicInteger(list.size());
    }

    @Override
    public final void onException(Throwable ex) {
        this.setException(ex);
    }

    @Override
    public final void onValue(T value) {
        if (this.count.decrementAndGet() == 0) {
            this.become(Future.VOID);
        }
    }

    @Override
    protected InterruptHandler getInterruptHandler() {
        return InterruptHandler.apply(this.list);
    }
}

