/*
 * Decompiled with CFR 0.152.
 */
package io.trane.future;

import java.util.Optional;
import java.util.function.Supplier;

public final class Local<T> {
    protected static final Optional<?>[] EMPTY = new Optional[0];
    private static ThreadLocal<Optional<?>[]> threadLocal = null;
    private static int size = 0;
    private final int position = Local.newPosition();

    public static final <T> Local<T> apply() {
        return new Local<T>();
    }

    protected static final Optional<?>[] save() {
        if (threadLocal == null) {
            return EMPTY;
        }
        Optional<?>[] state = threadLocal.get();
        if (state == null) {
            return EMPTY;
        }
        return state;
    }

    protected static final void restore(Optional<?>[] saved) {
        if (threadLocal != null) {
            threadLocal.set(saved);
        }
    }

    private static final synchronized int newPosition() {
        if (threadLocal == null) {
            threadLocal = new ThreadLocal();
        }
        return size++;
    }

    private Local() {
    }

    public final void update(T value) {
        this.set(Optional.of(value));
    }

    public final void set(Optional<T> opt) {
        Optional<?>[] ctx = threadLocal.get();
        if (ctx == null) {
            ctx = new Optional[size];
        } else {
            Optional<?>[] oldCtx = ctx;
            ctx = new Optional[size];
            System.arraycopy(oldCtx, 0, ctx, 0, oldCtx.length);
        }
        ctx[this.position] = opt;
        threadLocal.set(ctx);
    }

    public final Optional<T> get() {
        Optional<?>[] ctx = threadLocal.get();
        if (ctx == null || ctx.length <= this.position) {
            return Optional.empty();
        }
        Optional<?> v = ctx[this.position];
        if (v == null) {
            return Optional.empty();
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <U> U let(T value, Supplier<U> s) {
        Optional<T> saved = this.get();
        this.set(Optional.of(value));
        try {
            U u = s.get();
            return u;
        }
        finally {
            this.set(saved);
        }
    }
}

