/*
 * Decompiled with CFR 0.152.
 */
package io.trane.future;

import io.trane.future.CheckedFutureException;
import io.trane.future.Continuation;
import io.trane.future.ExceptionFuture;
import io.trane.future.Future;
import io.trane.future.InterruptHandler;
import io.trane.future.LinkedContinuation;
import io.trane.future.Local;
import io.trane.future.Responder;
import io.trane.future.SatisfiedFuture;
import io.trane.future.TimeoutException;
import io.trane.future.Transformer;
import io.trane.future.Unsafe;
import io.trane.future.ValueFuture;
import io.trane.future.WaitQueue;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Promise<T>
implements Future<T> {
    private static final long STATE_OFFSET = Unsafe.objectFieldOffset(Promise.class, "state");
    private static final Logger LOGGER = Logger.getLogger(Promise.class.getName());
    volatile Object state;

    public static final <T> Promise<T> apply(final List<? extends InterruptHandler> handlers) {
        final Optional[] savedContext = Local.save();
        if (savedContext.length == 0) {
            return new Promise<T>(){

                @Override
                protected final Optional<?>[] getSavedContext() {
                    return Local.EMPTY;
                }

                @Override
                protected final InterruptHandler getInterruptHandler() {
                    return InterruptHandler.apply(handlers);
                }
            };
        }
        return new Promise<T>(){

            @Override
            protected final Optional<?>[] getSavedContext() {
                return savedContext;
            }

            @Override
            protected final InterruptHandler getInterruptHandler() {
                return InterruptHandler.apply(handlers);
            }
        };
    }

    public static final <T> Promise<T> apply(final InterruptHandler handler) {
        final Optional[] savedContext = Local.save();
        if (savedContext.length == 0) {
            return new Promise<T>(){

                @Override
                protected final Optional<?>[] getSavedContext() {
                    return Local.EMPTY;
                }

                @Override
                protected final InterruptHandler getInterruptHandler() {
                    return handler;
                }
            };
        }
        return new Promise<T>(){

            @Override
            protected final Optional<?>[] getSavedContext() {
                return savedContext;
            }

            @Override
            protected final InterruptHandler getInterruptHandler() {
                return handler;
            }
        };
    }

    public static final <T> Promise<T> apply() {
        final Optional[] savedContext = Local.save();
        if (savedContext.length == 0) {
            return new Promise<T>(){

                @Override
                protected final Optional<?>[] getSavedContext() {
                    return Local.EMPTY;
                }
            };
        }
        return new Promise<T>(){

            @Override
            protected final Optional<?>[] getSavedContext() {
                return savedContext;
            }
        };
    }

    public static final <T> Promise<T> create(final Function<Promise<T>, InterruptHandler> handlerBuilder) {
        final Optional[] savedContext = Local.save();
        if (savedContext.length == 0) {
            return new Promise<T>(){
                final InterruptHandler handler;
                {
                    this.handler = (InterruptHandler)handlerBuilder.apply(this);
                }

                @Override
                protected final Optional<?>[] getSavedContext() {
                    return Local.EMPTY;
                }

                @Override
                protected final InterruptHandler getInterruptHandler() {
                    return this.handler;
                }
            };
        }
        return new Promise<T>(){
            final InterruptHandler handler;
            {
                this.handler = (InterruptHandler)handlerBuilder.apply(this);
            }

            @Override
            protected final Optional<?>[] getSavedContext() {
                return savedContext;
            }

            @Override
            protected final InterruptHandler getInterruptHandler() {
                return this.handler;
            }
        };
    }

    protected static final <T> Promise<T> apply(final InterruptHandler h1, final InterruptHandler h2) {
        final Optional[] savedContext = Local.save();
        return new Promise<T>(){

            @Override
            protected final Optional<?>[] getSavedContext() {
                return savedContext;
            }

            @Override
            protected final InterruptHandler getInterruptHandler() {
                return InterruptHandler.apply(h1, h2);
            }
        };
    }

    protected Promise() {
    }

    protected InterruptHandler getInterruptHandler() {
        return null;
    }

    protected Optional<?>[] getSavedContext() {
        return null;
    }

    private final boolean cas(Object oldState, Object newState) {
        return Unsafe.compareAndSwapObject(this, STATE_OFFSET, oldState, newState);
    }

    public final void become(Future<T> result) {
        if (!this.becomeIfEmpty(result)) {
            throw new IllegalStateException("Can't set result " + result + " for promise with state " + this.state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean becomeIfEmpty(Future<T> result) {
        Optional<?>[] originalContext;
        Optional<?>[] savedContext = this.getSavedContext();
        if (savedContext != null && (originalContext = Local.save()) != savedContext) {
            Local.restore(savedContext);
            try {
                boolean bl = this.trySetState(result);
                return bl;
            }
            finally {
                Local.restore(originalContext);
            }
        }
        return this.trySetState(result);
    }

    public final boolean trySetState(Future<T> result) {
        try {
            Object curr;
            do {
                if ((curr = this.state) instanceof SatisfiedFuture) {
                    return false;
                }
                if (curr instanceof Promise && !(curr instanceof Continuation)) {
                    return ((Promise)curr).becomeIfEmpty(result);
                }
                if (curr instanceof LinkedContinuation) {
                    return ((LinkedContinuation)curr).becomeIfEmpty(result);
                }
                if (!(result instanceof Promise)) continue;
                super.link(this);
                return true;
            } while (!this.cas(curr, result));
            if (curr != null) {
                ((WaitQueue)curr).flush(result);
            }
            return true;
        }
        catch (StackOverflowError ex) {
            if (!(this instanceof Continuation)) {
                LOGGER.log(Level.SEVERE, "FATAL: Stack overflow when satisfying promise, the promise and its continuations won't be satisfied. Use `Future.tailrec` or increase the stack size (-Xss) if the future isn't recursive.", ex);
            }
            throw ex;
        }
    }

    protected final WaitQueue<T> safeFlush(Future<T> result) {
        Object curr;
        do {
            if ((curr = this.state) instanceof Promise && !(curr instanceof Continuation)) {
                return ((Promise)curr).safeFlush(result);
            }
            if (curr instanceof LinkedContinuation) {
                return ((LinkedContinuation)curr).safeFlush(result);
            }
            if (!(result instanceof Promise)) continue;
            super.link(this);
            return null;
        } while (!this.cas(curr, result));
        return (WaitQueue)curr;
    }

    private final void link(Promise<T> target) {
        Object newState;
        Object curr;
        do {
            if (!((curr = this.state) instanceof SatisfiedFuture)) continue;
            target.become((SatisfiedFuture)curr);
            return;
        } while (!this.cas(curr, newState = target instanceof Continuation ? new LinkedContinuation((Continuation)target) : target));
        if (curr != null) {
            ((WaitQueue)curr).forward(target);
        }
    }

    protected final <R> Future<R> continuation(Continuation<T, R> c) {
        Object curr;
        while (true) {
            if ((curr = this.state) == null) {
                if (!this.cas(curr, c)) continue;
                return c;
            }
            if (curr instanceof WaitQueue) {
                if (!this.cas(curr, ((WaitQueue)curr).add(c))) continue;
                return c;
            }
            if (curr instanceof SatisfiedFuture) {
                c.flush((SatisfiedFuture)curr);
                return c;
            }
            if (curr instanceof Promise && !(curr instanceof Continuation)) {
                return ((Promise)curr).continuation(c);
            }
            if (curr instanceof LinkedContinuation) break;
        }
        return ((LinkedContinuation)curr).continuation(c);
    }

    private final Promise<T> compress() {
        Object curr;
        while ((curr = this.state) instanceof Promise && !(curr instanceof Continuation)) {
            Promise<T> target = ((Promise)curr).compress();
            if (curr != target && !this.cas(curr, target)) continue;
            return target;
        }
        return this;
    }

    public final void setValue(T value) {
        this.become(new ValueFuture<T>(value));
    }

    public final void setException(Throwable ex) {
        this.become(new ExceptionFuture(ex));
    }

    @Override
    public final void raise(Throwable ex) {
        Object curr = this.state;
        if (curr instanceof SatisfiedFuture) {
            return;
        }
        if (curr instanceof Promise && !(curr instanceof Continuation)) {
            ((Promise)curr).raise(ex);
        } else if (curr instanceof LinkedContinuation) {
            ((LinkedContinuation)curr).raise(ex);
        } else {
            InterruptHandler interruptHandler = this.getInterruptHandler();
            if (interruptHandler != null) {
                interruptHandler.raise(ex);
            }
        }
    }

    @Override
    public Future<T> interruptible() {
        Promise<T> r = Promise.create(p -> ex -> p.setException(ex));
        this.proxyTo(r);
        return r;
    }

    @Override
    public final boolean isDefined() {
        Object curr = this.state;
        if (curr instanceof SatisfiedFuture) {
            return true;
        }
        if (curr instanceof Promise && !(curr instanceof Continuation)) {
            return ((Promise)curr).isDefined();
        }
        if (curr instanceof LinkedContinuation) {
            return ((LinkedContinuation)curr).isDefined();
        }
        return false;
    }

    @Override
    public final T get(Duration timeout) throws CheckedFutureException {
        Object curr = this.state;
        if (curr instanceof Future && !(curr instanceof Continuation) && ((Future)curr).isDefined()) {
            return ((Future)curr).get(Duration.ZERO);
        }
        if (curr instanceof LinkedContinuation && ((LinkedContinuation)curr).isDefined()) {
            return (T)((LinkedContinuation)curr).get(Duration.ZERO);
        }
        this.join(timeout);
        return ((Future)this.state).get(Duration.ZERO);
    }

    @Override
    public final void join(Duration timeout) throws CheckedFutureException {
        ReleaseOnRunLatch latch = new ReleaseOnRunLatch();
        this.ensure(latch);
        try {
            if (!latch.await(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
                throw new TimeoutException();
            }
        }
        catch (InterruptedException ex) {
            throw new CheckedFutureException(ex);
        }
    }

    @Override
    public final <R> Future<R> map(Function<? super T, ? extends R> f) {
        if (this.getInterruptHandler() != null) {
            return this.continuation(new Map<T, R>(f){

                @Override
                protected final InterruptHandler getInterruptHandler() {
                    return Promise.this;
                }
            });
        }
        return this.continuation(new Map<T, R>(f));
    }

    @Override
    public final <R> Future<R> flatMap(Function<? super T, ? extends Future<R>> f) {
        if (this.getInterruptHandler() != null) {
            return this.continuation(new FlatMap<T, R>(f){

                @Override
                protected final InterruptHandler getInterruptHandler() {
                    return Promise.this;
                }
            });
        }
        return this.continuation(new FlatMap(f));
    }

    @Override
    public <R> Future<R> transform(Transformer<? super T, ? extends R> t) {
        if (this.getInterruptHandler() != null) {
            return this.continuation(new Transform<T, R>(t){

                @Override
                protected final InterruptHandler getInterruptHandler() {
                    return Promise.this;
                }
            });
        }
        return this.continuation(new Transform<T, R>(t));
    }

    @Override
    public <R> Future<R> transformWith(Transformer<? super T, ? extends Future<R>> t) {
        if (this.getInterruptHandler() != null) {
            return this.continuation(new TransformWith<T, R>(t){

                @Override
                protected final InterruptHandler getInterruptHandler() {
                    return Promise.this;
                }
            });
        }
        return this.continuation(new TransformWith(t));
    }

    @Override
    public <U, R> Future<R> biMap(final Future<U> other, BiFunction<? super T, ? super U, ? extends R> f) {
        if (this.getInterruptHandler() != null) {
            return this.continuation(new BiMap<T, U, R>(other, f){

                @Override
                protected final InterruptHandler getInterruptHandler() {
                    return InterruptHandler.apply(Promise.this, other);
                }
            });
        }
        return this.continuation(new BiMap<T, U, R>(other, f));
    }

    @Override
    public <U, R> Future<R> biFlatMap(final Future<U> other, BiFunction<? super T, ? super U, ? extends Future<R>> f) {
        if (this.getInterruptHandler() != null) {
            return this.continuation(new BiFlatMap<T, U, R>(other, f){

                @Override
                protected final InterruptHandler getInterruptHandler() {
                    return InterruptHandler.apply(Promise.this, other);
                }
            });
        }
        return this.continuation(new BiFlatMap(other, f));
    }

    @Override
    public final Future<T> ensure(Runnable f) {
        if (this.getInterruptHandler() != null) {
            return this.continuation(new Ensure<T>(f){

                @Override
                protected final InterruptHandler getInterruptHandler() {
                    return Promise.this;
                }
            });
        }
        return this.continuation(new Ensure(f));
    }

    @Override
    public final Future<T> onSuccess(Consumer<? super T> c) {
        if (this.getInterruptHandler() != null) {
            return this.continuation(new OnSuccess<T>(c){

                @Override
                protected final InterruptHandler getInterruptHandler() {
                    return Promise.this;
                }
            });
        }
        return this.continuation(new OnSuccess<T>(c));
    }

    @Override
    public final Future<T> onFailure(Consumer<Throwable> c) {
        if (this.getInterruptHandler() != null) {
            return this.continuation(new OnFailure<T>(c){

                @Override
                protected final InterruptHandler getInterruptHandler() {
                    return Promise.this;
                }
            });
        }
        return this.continuation(new OnFailure(c));
    }

    @Override
    public final Future<T> respond(Responder<? super T> r) {
        if (this.getInterruptHandler() != null) {
            return this.continuation(new Respond<T>(r){

                @Override
                protected final InterruptHandler getInterruptHandler() {
                    return Promise.this;
                }
            });
        }
        return this.continuation(new Respond<T>(r));
    }

    @Override
    public final Future<T> rescue(Function<Throwable, ? extends Future<T>> f) {
        if (this.getInterruptHandler() != null) {
            return this.continuation(new Rescue<T>(f){

                @Override
                protected final InterruptHandler getInterruptHandler() {
                    return Promise.this;
                }
            });
        }
        return this.continuation(new Rescue(f));
    }

    @Override
    public final Future<Void> voided() {
        if (this.getInterruptHandler() != null) {
            return this.continuation(new Voided<T>(){

                @Override
                protected final InterruptHandler getInterruptHandler() {
                    return Promise.this;
                }
            });
        }
        return this.continuation(new Voided());
    }

    @Override
    public final Future<T> delayed(Duration delay, ScheduledExecutorService scheduler) {
        DelayedPromise p = new DelayedPromise();
        scheduler.schedule(p, delay.toMillis(), TimeUnit.MILLISECONDS);
        return p;
    }

    @Override
    public final void proxyTo(final Promise<T> p) {
        if (p.isDefined()) {
            throw new IllegalStateException("Cannot call proxyTo on an already satisfied Promise.");
        }
        Responder r = new Responder<T>(){

            @Override
            public final void onException(Throwable ex) {
                p.setException(ex);
            }

            @Override
            public final void onValue(T value) {
                p.setValue(value);
            }
        };
        this.respond(r);
    }

    @Override
    public final Future<T> within(Duration timeout, ScheduledExecutorService scheduler, Throwable exception) {
        if (timeout.toMillis() == Long.MAX_VALUE) {
            return this;
        }
        WithinPromise p = new WithinPromise(this, timeout, scheduler, exception);
        this.respond(p);
        return p;
    }

    protected String toStringPrefix() {
        return "Promise";
    }

    public final String toString() {
        Object curr = this.state;
        String stateString = curr instanceof SatisfiedFuture ? curr.toString() : (curr instanceof Promise && !(curr instanceof Continuation) || curr instanceof LinkedContinuation ? String.format("Linked(%s)", curr.toString()) : "Waiting");
        return String.format("%s(%s)@%s", this.toStringPrefix(), stateString, Integer.toHexString(this.hashCode()));
    }

    private static final class WithinPromise<T>
    extends Promise<T>
    implements Responder<T>,
    Runnable {
        private final InterruptHandler handler;
        private final ScheduledFuture<?> task;
        private final Throwable exception;

        public WithinPromise(InterruptHandler handler, Duration timeout, ScheduledExecutorService scheduler, Throwable exception) {
            this.handler = handler;
            this.task = scheduler.schedule(this, timeout.toMillis(), TimeUnit.MILLISECONDS);
            this.exception = exception;
        }

        @Override
        public final void onException(Throwable ex) {
            this.task.cancel(false);
            this.becomeIfEmpty(Future.exception(ex));
        }

        @Override
        public final void onValue(T value) {
            this.task.cancel(false);
            this.becomeIfEmpty(Future.value(value));
        }

        @Override
        public final void run() {
            this.handler.raise(this.exception);
            this.becomeIfEmpty(Future.exception(this.exception));
        }

        @Override
        protected final InterruptHandler getInterruptHandler() {
            return this.handler;
        }
    }

    private final class DelayedPromise
    extends Promise<T>
    implements Runnable {
        private DelayedPromise() {
        }

        @Override
        public final void run() {
            this.become(Promise.this);
        }

        @Override
        protected final InterruptHandler getInterruptHandler() {
            return Promise.this;
        }
    }

    private static class Voided<T>
    extends Continuation<T, Void> {
        private Voided() {
        }

        @Override
        final Future<Void> apply(Future<T> result) {
            return result.voided();
        }
    }

    private static class Rescue<T>
    extends Continuation<T, T> {
        private final Function<Throwable, ? extends Future<T>> f;

        public Rescue(Function<Throwable, ? extends Future<T>> f) {
            this.f = f;
        }

        @Override
        final Future<T> apply(Future<T> result) {
            return result.rescue(this.f);
        }
    }

    private static class Respond<T>
    extends Continuation<T, T> {
        private final Responder<? super T> r;

        public Respond(Responder<? super T> r) {
            this.r = r;
        }

        @Override
        final Future<T> apply(Future<T> result) {
            return result.respond(this.r);
        }
    }

    private static class OnFailure<T>
    extends Continuation<T, T> {
        private final Consumer<Throwable> c;

        public OnFailure(Consumer<Throwable> c) {
            this.c = c;
        }

        @Override
        final Future<T> apply(Future<T> result) {
            return result.onFailure(this.c);
        }
    }

    private static class OnSuccess<T>
    extends Continuation<T, T> {
        private final Consumer<? super T> c;

        public OnSuccess(Consumer<? super T> c) {
            this.c = c;
        }

        @Override
        final Future<T> apply(Future<T> result) {
            return result.onSuccess(this.c);
        }
    }

    private static class Ensure<T>
    extends Continuation<T, T> {
        private final Runnable f;

        public Ensure(Runnable f) {
            this.f = f;
        }

        @Override
        final Future<T> apply(Future<T> result) {
            return result.ensure(this.f);
        }
    }

    private static class BiFlatMap<T, U, R>
    extends Continuation<T, R> {
        private final BiFunction<? super T, ? super U, ? extends Future<R>> f;
        private final Future<U> other;

        public BiFlatMap(Future<U> other, BiFunction<? super T, ? super U, ? extends Future<R>> f) {
            this.other = other;
            this.f = f;
        }

        @Override
        final Future<R> apply(Future<T> result) {
            return result.biFlatMap(this.other, this.f);
        }
    }

    private static class BiMap<T, U, R>
    extends Continuation<T, R> {
        private final BiFunction<? super T, ? super U, ? extends R> f;
        private final Future<U> other;

        public BiMap(Future<U> other, BiFunction<? super T, ? super U, ? extends R> f) {
            this.other = other;
            this.f = f;
        }

        @Override
        final Future<R> apply(Future<T> result) {
            return result.biMap(this.other, this.f);
        }
    }

    private static class TransformWith<T, R>
    extends Continuation<T, R> {
        private final Transformer<? super T, ? extends Future<R>> t;

        public TransformWith(Transformer<? super T, ? extends Future<R>> t) {
            this.t = t;
        }

        @Override
        final Future<R> apply(Future<T> result) {
            return result.transformWith(this.t);
        }
    }

    private static class Transform<T, R>
    extends Continuation<T, R> {
        private final Transformer<? super T, ? extends R> t;

        public Transform(Transformer<? super T, ? extends R> t) {
            this.t = t;
        }

        @Override
        final Future<R> apply(Future<T> result) {
            return result.transform(this.t);
        }
    }

    private static class FlatMap<T, R>
    extends Continuation<T, R> {
        private final Function<? super T, ? extends Future<R>> f;

        public FlatMap(Function<? super T, ? extends Future<R>> f) {
            this.f = f;
        }

        @Override
        final Future<R> apply(Future<T> result) {
            return result.flatMap(this.f);
        }
    }

    private static class Map<T, R>
    extends Continuation<T, R> {
        private final Function<? super T, ? extends R> f;

        public Map(Function<? super T, ? extends R> f) {
            this.f = f;
        }

        @Override
        final Future<R> apply(Future<T> result) {
            return result.map(this.f);
        }
    }

    private static final class ReleaseOnRunLatch
    extends CountDownLatch
    implements Runnable {
        public ReleaseOnRunLatch() {
            super(1);
        }

        @Override
        public final void run() {
            super.countDown();
        }
    }
}

