/*
 * Decompiled with CFR 0.152.
 */
package io.trane.future;

import io.trane.future.DelayedSatisfiedFuture;
import io.trane.future.Future;
import io.trane.future.NonFatalException;
import io.trane.future.Promise;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

interface SatisfiedFuture<T>
extends Future<T> {
    public static final Logger logger = Logger.getLogger(SatisfiedFuture.class.getName());

    @Override
    default public Future<T> ensure(Runnable r) {
        try {
            r.run();
        }
        catch (Throwable ex) {
            logger.log(Level.WARNING, "Error when executing `respond` callback " + r + "for" + this, ex);
            NonFatalException.verify(ex);
        }
        return this;
    }

    @Override
    default public void raise(Throwable ex) {
    }

    @Override
    default public Future<T> interruptible() {
        return this;
    }

    @Override
    default public boolean isDefined() {
        return true;
    }

    @Override
    default public void proxyTo(Promise<T> p) {
        if (!p.becomeIfEmpty(this)) {
            throw new IllegalStateException("Cannot call proxyTo on an already satisfied Promise.");
        }
    }

    @Override
    default public Future<T> delayed(Duration delay, ScheduledExecutorService scheduler) {
        DelayedSatisfiedFuture p = new DelayedSatisfiedFuture(this);
        scheduler.schedule(p, delay.toMillis(), TimeUnit.MILLISECONDS);
        return p;
    }

    @Override
    default public Future<T> within(Duration timeout, ScheduledExecutorService scheduler, Throwable exception) {
        return this;
    }

    @Override
    default public void join(Duration timeout) {
    }
}

