/*
 * Decompiled with CFR 0.152.
 */
package io.trane.future;

import io.trane.future.Future;
import io.trane.future.TailrecPromise;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;

public final class Tailrec {
    private static final int DEFAULT_BATCH_SIZE = Optional.ofNullable(System.getProperty("io.trane.future.defaultBatchSize")).map(Integer::parseInt).orElse(512);
    private static final ThreadLocal<Tailrec> local = new ThreadLocal<Tailrec>(){

        @Override
        public Tailrec initialValue() {
            return new Tailrec();
        }
    };
    private ArrayList<Runnable> tasks = null;
    private int syncPermits = 0;
    private boolean running = false;

    private final boolean runSync() {
        return this.syncPermits-- > 0;
    }

    private final void submit(Runnable r, int batchSize) {
        this.syncPermits = batchSize;
        this.tasks = new ArrayList(1);
        this.tasks.add(r);
        if (!this.running) {
            this.run();
            this.syncPermits = 0;
        }
    }

    private final void run() {
        this.running = true;
        while (this.tasks != null) {
            ArrayList<Runnable> pending = this.tasks;
            this.tasks = null;
            for (int i = 0; i < pending.size(); ++i) {
                pending.get(i).run();
            }
        }
        this.running = false;
    }

    public static final <T> Future<T> apply(Supplier<Future<T>> sup) {
        return Tailrec.apply(DEFAULT_BATCH_SIZE, sup);
    }

    public static final <T> Future<T> apply(int batchSize, Supplier<Future<T>> sup) {
        Tailrec scheduler = local.get();
        if (scheduler.runSync()) {
            return sup.get();
        }
        TailrecPromise<T> p = new TailrecPromise<T>(sup);
        scheduler.submit(p, batchSize);
        return p;
    }
}

