/*
 * Decompiled with CFR 0.152.
 */
package io.trane.future;

import io.trane.future.ExceptionFuture;
import io.trane.future.Future;
import io.trane.future.NonFatalException;
import io.trane.future.Responder;
import io.trane.future.SatisfiedFuture;
import io.trane.future.Transformer;
import java.time.Duration;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ValueFuture<T>
implements SatisfiedFuture<T> {
    private static final Logger logger = Logger.getLogger(ExceptionFuture.class.getName());
    final T value;

    protected ValueFuture(T value) {
        this.value = value;
    }

    @Override
    public final <R> Future<R> map(Function<? super T, ? extends R> f) {
        try {
            return new ValueFuture<R>(f.apply(this.value));
        }
        catch (Throwable ex) {
            return new ExceptionFuture(ex);
        }
    }

    @Override
    public final <R> Future<R> flatMap(Function<? super T, ? extends Future<R>> f) {
        try {
            return f.apply(this.value);
        }
        catch (Throwable ex) {
            return new ExceptionFuture(ex);
        }
    }

    @Override
    public <R> Future<R> transform(Transformer<? super T, ? extends R> t) {
        try {
            return new ValueFuture<R>(t.onValue(this.value));
        }
        catch (Throwable ex) {
            return new ExceptionFuture(ex);
        }
    }

    @Override
    public <R> Future<R> transformWith(Transformer<? super T, ? extends Future<R>> t) {
        try {
            return t.onValue(this.value);
        }
        catch (Throwable ex) {
            return new ExceptionFuture(ex);
        }
    }

    @Override
    public <U, R> Future<R> biMap(Future<U> other, BiFunction<? super T, ? super U, ? extends R> f) {
        return other.map(u -> f.apply((T)this.value, (Object)u));
    }

    @Override
    public <U, R> Future<R> biFlatMap(Future<U> other, BiFunction<? super T, ? super U, ? extends Future<R>> f) {
        return other.flatMap(u -> (Future)f.apply((T)this.value, (Object)u));
    }

    @Override
    public final Future<T> onSuccess(Consumer<? super T> c) {
        try {
            c.accept(this.value);
        }
        catch (Throwable ex) {
            logger.log(Level.WARNING, "Error executing `onSuccess` callback " + c + "for" + this, ex);
            NonFatalException.verify(ex);
        }
        return this;
    }

    @Override
    public final Future<T> onFailure(Consumer<Throwable> c) {
        return this;
    }

    @Override
    public final Future<T> respond(Responder<? super T> r) {
        try {
            r.onValue(this.value);
        }
        catch (Throwable ex) {
            logger.log(Level.WARNING, "Error when executing `respond` callback " + r + "for" + this, ex);
            NonFatalException.verify(ex);
        }
        return this;
    }

    @Override
    public final Future<T> rescue(Function<Throwable, ? extends Future<T>> f) {
        return this;
    }

    @Override
    public final Future<Void> voided() {
        return VOID;
    }

    @Override
    public final T get(Duration timeout) {
        return this.value;
    }

    public final String toString() {
        return String.format("ValueFuture(%s)", this.value);
    }

    public final int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueFuture other = (ValueFuture)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

