/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.models;

import com.google.gson.JsonObject;

public class BatchMessageResult {
    private final String id;
    private final String to;
    private final String status;
    private final String error;

    public BatchMessageResult(JsonObject json) {
        this.id = this.getStringOrNull(json, "id");
        this.to = this.getStringOrNull(json, "to");
        this.status = this.getStringOrNull(json, "status");
        this.error = this.getStringOrNull(json, "error");
    }

    private String getStringOrNull(JsonObject json, String key) {
        return json.has(key) && !json.get(key).isJsonNull() ? json.get(key).getAsString() : null;
    }

    public String getId() {
        return this.id;
    }

    public String getTo() {
        return this.to;
    }

    public String getStatus() {
        return this.status;
    }

    public String getError() {
        return this.error;
    }

    public boolean isSuccess() {
        return "queued".equals(this.status);
    }

    public boolean isFailed() {
        return "failed".equals(this.status);
    }

    public String toString() {
        return "BatchMessageResult{id='" + this.id + "', to='" + this.to + "', status='" + this.status + "'}";
    }
}

