/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.models;

import com.google.gson.JsonObject;
import java.time.Instant;
import java.time.format.DateTimeParseException;

public class CancelScheduledMessageResponse {
    private final String id;
    private final String status;
    private final int creditsRefunded;
    private final Instant cancelledAt;

    public CancelScheduledMessageResponse(JsonObject json) {
        this.id = this.getStringOrNull(json, "id");
        this.status = this.getStringOrNull(json, "status");
        this.creditsRefunded = json.has("credits_refunded") ? json.get("credits_refunded").getAsInt() : 0;
        this.cancelledAt = this.parseInstant(this.getStringOrNull(json, "cancelled_at"));
    }

    private String getStringOrNull(JsonObject json, String key) {
        return json.has(key) && !json.get(key).isJsonNull() ? json.get(key).getAsString() : null;
    }

    private Instant parseInstant(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Instant.parse(value);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getStatus() {
        return this.status;
    }

    public int getCreditsRefunded() {
        return this.creditsRefunded;
    }

    public Instant getCancelledAt() {
        return this.cancelledAt;
    }

    public String toString() {
        return "CancelScheduledMessageResponse{id='" + this.id + "', status='" + this.status + "', creditsRefunded=" + this.creditsRefunded + "}";
    }
}

