/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.models;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.sendly.models.Message;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MessageList
implements Iterable<Message> {
    private final List<Message> messages = new ArrayList<Message>();
    private final int total;
    private final int limit;
    private final int offset;
    private final boolean hasMore;

    public MessageList(JsonObject json) {
        if (json.has("data") && json.get("data").isJsonArray()) {
            JsonArray data = json.getAsJsonArray("data");
            for (int i = 0; i < data.size(); ++i) {
                this.messages.add(new Message(data.get(i).getAsJsonObject()));
            }
        }
        JsonObject pagination = json.has("pagination") ? json.getAsJsonObject("pagination") : new JsonObject();
        this.total = pagination.has("total") ? pagination.get("total").getAsInt() : this.messages.size();
        this.limit = pagination.has("limit") ? pagination.get("limit").getAsInt() : 20;
        this.offset = pagination.has("offset") ? pagination.get("offset").getAsInt() : 0;
        this.hasMore = pagination.has("has_more") && pagination.get("has_more").getAsBoolean();
    }

    public List<Message> getData() {
        return this.messages;
    }

    public int getTotal() {
        return this.total;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public int size() {
        return this.messages.size();
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public Message first() {
        return this.messages.isEmpty() ? null : this.messages.get(0);
    }

    public Message last() {
        return this.messages.isEmpty() ? null : this.messages.get(this.messages.size() - 1);
    }

    public Message get(int index) {
        return this.messages.get(index);
    }

    @Override
    public Iterator<Message> iterator() {
        return this.messages.iterator();
    }
}

