/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.models;

import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.time.Instant;
import java.time.format.DateTimeParseException;

public class ScheduledMessage {
    public static final String STATUS_SCHEDULED = "scheduled";
    public static final String STATUS_SENT = "sent";
    public static final String STATUS_CANCELLED = "cancelled";
    public static final String STATUS_FAILED = "failed";
    private final String id;
    private final String to;
    private final String text;
    private final String from;
    private final String status;
    @SerializedName(value="scheduled_at")
    private final Instant scheduledAt;
    @SerializedName(value="credits_reserved")
    private final int creditsReserved;
    @SerializedName(value="created_at")
    private final Instant createdAt;
    @SerializedName(value="cancelled_at")
    private final Instant cancelledAt;
    @SerializedName(value="sent_at")
    private final Instant sentAt;
    private final String error;

    public ScheduledMessage(JsonObject json) {
        this.id = this.getStringOrNull(json, "id");
        this.to = this.getStringOrNull(json, "to");
        this.text = this.getStringOrNull(json, "text");
        this.from = this.getStringOrNull(json, "from");
        this.status = this.getStringOrNull(json, "status");
        this.scheduledAt = this.parseInstant(this.getStringOrNull(json, "scheduled_at"));
        this.creditsReserved = json.has("credits_reserved") ? json.get("credits_reserved").getAsInt() : 0;
        this.createdAt = this.parseInstant(this.getStringOrNull(json, "created_at"));
        this.cancelledAt = this.parseInstant(this.getStringOrNull(json, "cancelled_at"));
        this.sentAt = this.parseInstant(this.getStringOrNull(json, "sent_at"));
        this.error = this.getStringOrNull(json, "error");
    }

    private String getStringOrNull(JsonObject json, String key) {
        return json.has(key) && !json.get(key).isJsonNull() ? json.get(key).getAsString() : null;
    }

    private Instant parseInstant(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Instant.parse(value);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getTo() {
        return this.to;
    }

    public String getText() {
        return this.text;
    }

    public String getFrom() {
        return this.from;
    }

    public String getStatus() {
        return this.status;
    }

    public Instant getScheduledAt() {
        return this.scheduledAt;
    }

    public int getCreditsReserved() {
        return this.creditsReserved;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getCancelledAt() {
        return this.cancelledAt;
    }

    public Instant getSentAt() {
        return this.sentAt;
    }

    public String getError() {
        return this.error;
    }

    public boolean isScheduled() {
        return STATUS_SCHEDULED.equals(this.status);
    }

    public boolean isSent() {
        return STATUS_SENT.equals(this.status);
    }

    public boolean isCancelled() {
        return STATUS_CANCELLED.equals(this.status);
    }

    public boolean isFailed() {
        return STATUS_FAILED.equals(this.status);
    }

    public String toString() {
        return "ScheduledMessage{id='" + this.id + "', to='" + this.to + "', status='" + this.status + "', scheduledAt=" + String.valueOf(this.scheduledAt) + ", creditsReserved=" + this.creditsReserved + "}";
    }
}

