/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.models;

public class SendMessageRequest {
    private final String to;
    private final String text;
    private final String messageType;

    public SendMessageRequest(String to, String text) {
        this(to, text, null);
    }

    public SendMessageRequest(String to, String text, String messageType) {
        this.to = to;
        this.text = text;
        this.messageType = messageType;
    }

    public String getTo() {
        return this.to;
    }

    public String getText() {
        return this.text;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String to;
        private String text;
        private String messageType;

        public Builder to(String to) {
            this.to = to;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        public SendMessageRequest build() {
            return new SendMessageRequest(this.to, this.text, this.messageType);
        }
    }
}

