/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.resources;

import com.sendly.Sendly;
import com.sendly.exceptions.SendlyException;
import com.sendly.models.CreateSessionRequest;
import com.sendly.models.ValidateSessionResponse;
import com.sendly.models.VerifySession;
import java.util.HashMap;

public class SessionsResource {
    private final Sendly client;

    public SessionsResource(Sendly client) {
        this.client = client;
    }

    public VerifySession create(CreateSessionRequest request) throws SendlyException {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("success_url", request.getSuccessUrl());
        if (request.getCancelUrl() != null) {
            body.put("cancel_url", request.getCancelUrl());
        }
        if (request.getBrandName() != null) {
            body.put("brand_name", request.getBrandName());
        }
        if (request.getBrandColor() != null) {
            body.put("brand_color", request.getBrandColor());
        }
        if (request.getMetadata() != null) {
            body.put("metadata", request.getMetadata());
        }
        return this.client.request("POST", "/verify/sessions", body, VerifySession.class);
    }

    public ValidateSessionResponse validate(String token) throws SendlyException {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("token", token);
        return this.client.request("POST", "/verify/sessions/validate", body, ValidateSessionResponse.class);
    }
}

