/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.resources;

import com.sendly.Sendly;
import com.sendly.exceptions.SendlyException;
import com.sendly.models.CheckVerificationResponse;
import com.sendly.models.ListVerificationsRequest;
import com.sendly.models.SendVerificationRequest;
import com.sendly.models.SendVerificationResponse;
import com.sendly.models.Verification;
import com.sendly.models.VerificationListResponse;
import com.sendly.resources.SessionsResource;
import java.util.HashMap;

public class VerifyResource {
    private final Sendly client;
    private final SessionsResource sessions;

    public VerifyResource(Sendly client) {
        this.client = client;
        this.sessions = new SessionsResource(client);
    }

    public SessionsResource sessions() {
        return this.sessions;
    }

    public SendVerificationResponse send(SendVerificationRequest request) throws SendlyException {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("to", request.getTo());
        if (request.getTemplateId() != null) {
            body.put("template_id", request.getTemplateId());
        }
        if (request.getProfileId() != null) {
            body.put("profile_id", request.getProfileId());
        }
        if (request.getAppName() != null) {
            body.put("app_name", request.getAppName());
        }
        if (request.getTimeoutSecs() != null) {
            body.put("timeout_secs", request.getTimeoutSecs());
        }
        if (request.getCodeLength() != null) {
            body.put("code_length", request.getCodeLength());
        }
        return this.client.request("POST", "/verify", body, SendVerificationResponse.class);
    }

    public CheckVerificationResponse check(String verificationId, String code) throws SendlyException {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("code", code);
        return this.client.request("POST", "/verify/" + verificationId + "/check", body, CheckVerificationResponse.class);
    }

    public Verification get(String verificationId) throws SendlyException {
        return this.client.request("GET", "/verify/" + verificationId, null, Verification.class);
    }

    public VerificationListResponse list(ListVerificationsRequest request) throws SendlyException {
        StringBuilder path = new StringBuilder("/verify");
        if (request != null) {
            StringBuilder params = new StringBuilder();
            if (request.getLimit() != null) {
                params.append(params.length() == 0 ? "?" : "&").append("limit=").append(request.getLimit());
            }
            if (request.getStatus() != null) {
                params.append(params.length() == 0 ? "?" : "&").append("status=").append(request.getStatus());
            }
            path.append((CharSequence)params);
        }
        return this.client.request("GET", path.toString(), null, VerificationListResponse.class);
    }

    public SendVerificationResponse resend(String verificationId) throws SendlyException {
        return this.client.request("POST", "/verify/" + verificationId + "/resend", null, SendVerificationResponse.class);
    }
}

