/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ly.count.sdk.java.CrashProcessor;
import ly.count.sdk.java.internal.Byteable;
import ly.count.sdk.java.internal.CoreFeature;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.LogCallback;
import ly.count.sdk.java.internal.Module;
import ly.count.sdk.java.internal.Utils;

public class Config {
    protected Log configLog;
    protected final URL serverURL;
    protected final String serverAppKey;
    protected int features = 0;
    protected int deviceIdStrategy = 0;
    protected String customDeviceId;
    protected LoggingLevel loggingLevel = LoggingLevel.OFF;
    protected LogCallback logListener = null;
    protected String sdkName = "java-native";
    protected String sdkVersion = "22.09.2";
    protected String applicationVersion;
    protected boolean usePOST = false;
    protected boolean enableBackendMode = false;
    protected Map<String, String> metricOverride = new HashMap<String, String>();
    protected String salt = null;
    protected int networkConnectionTimeout = 30;
    protected int networkReadTimeout = 30;
    protected int networkRequestCooldown = 1000;
    protected int networkImportantRequestCooldown = 5000;
    protected Set<String> publicKeyPins = null;
    protected Set<String> certificatePins = null;
    protected int sendUpdateEachSeconds = 30;
    protected int eventsBufferSize = 10;
    protected String crashProcessorClass = null;
    protected Map<Integer, Class<? extends Module>> moduleOverrides = null;
    protected boolean requiresConsent = false;
    protected Boolean starRatingIsDialogCancelable = null;
    protected Boolean starRatingDisabledAutomaticForNewVersions = null;
    protected long ratingWidgetTimeout = 3000L;
    protected int starRatingSessionLimit = -1;
    protected String starRatingTextTitle = null;
    protected String starRatingTextMessage = null;
    protected String starRatingTextDismiss = null;
    protected Boolean automaticStarRatingShouldBeShown = null;
    protected Boolean enableAutomaticRemoteConfig = null;
    protected Long remoteConfigUpdateRequestTimeout = null;
    protected int requestQueueMaxSize = 1000;

    public Config(String serverURL, String serverAppKey) {
        if (serverURL != null && serverURL.length() > 0 && serverURL.charAt(serverURL.length() - 1) == '/') {
            serverURL = serverURL.substring(0, serverURL.length() - 1);
        }
        try {
            this.serverURL = new URL(serverURL);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        this.serverAppKey = serverAppKey;
    }

    public Config setDeviceIdFallbackAllowed(boolean deviceIdFallbackAllowed) {
        return this;
    }

    public Config enableFeatures(Feature ... features) {
        if (features == null) {
            if (this.configLog != null) {
                this.configLog.e("[ConfigCore] Features array cannot be null");
            }
        } else {
            for (Feature f : features) {
                if (f == null) {
                    if (this.configLog == null) continue;
                    this.configLog.e("[ConfigCore] Feature cannot be null");
                    continue;
                }
                this.features |= f.getIndex();
            }
        }
        return this;
    }

    public Config disableFeatures(Feature ... features) {
        if (features == null) {
            if (this.configLog != null) {
                this.configLog.e("[ConfigCore] Features array cannot be null");
            }
        } else {
            for (Feature f : features) {
                if (f == null) {
                    if (this.configLog == null) continue;
                    this.configLog.e("[ConfigCore] Feature cannot be null");
                    continue;
                }
                this.features &= ~f.getIndex();
            }
        }
        return this;
    }

    public Config setLogListener(LogCallback logCallback) {
        this.logListener = logCallback;
        return this;
    }

    public Config setFeatures(Feature ... features) {
        this.features = 0;
        if (features != null && features.length > 0) {
            for (int i = 0; i < features.length; ++i) {
                if (features[i] == null) {
                    if (this.configLog == null) continue;
                    this.configLog.e("[ConfigCore] " + i + "-th feature is null in setFeatures");
                    continue;
                }
                this.features |= features[i].index;
            }
        }
        return this;
    }

    public Config setDeviceIdStrategy(DeviceIdStrategy strategy, String customDeviceId) {
        if (strategy == null) {
            if (this.configLog != null) {
                this.configLog.e("[ConfigCore] DeviceIdStrategy cannot be null");
            }
        } else {
            if (strategy == DeviceIdStrategy.CUSTOM_ID) {
                return this.setCustomDeviceId(customDeviceId);
            }
            this.deviceIdStrategy = strategy.index;
        }
        return this;
    }

    public Config setDeviceIdStrategy(DeviceIdStrategy strategy) {
        return this.setDeviceIdStrategy(strategy, null);
    }

    public Config setCustomDeviceId(String customDeviceId) {
        if (Utils.isEmptyOrNull(customDeviceId)) {
            if (this.configLog != null) {
                this.configLog.e("[ConfigCore] DeviceIdStrategy.CUSTOM_ID strategy cannot be used without device id specified");
            }
        } else {
            this.customDeviceId = customDeviceId;
            this.deviceIdStrategy = DeviceIdStrategy.CUSTOM_ID.index;
        }
        return this;
    }

    public DeviceIdStrategy getDeviceIdStrategyEnum() {
        return DeviceIdStrategy.fromIndex(this.deviceIdStrategy);
    }

    public Config enableUsePOST() {
        this.usePOST = true;
        return this;
    }

    public Config setUsePOST(boolean usePOST) {
        this.usePOST = usePOST;
        return this;
    }

    public Config enableBackendMode() {
        this.enableBackendMode = true;
        return this;
    }

    public int getRequestQueueMaxSize() {
        return this.requestQueueMaxSize;
    }

    public Config setRequestQueueMaxSize(int requestQueueMaxSize) {
        this.requestQueueMaxSize = requestQueueMaxSize;
        return this;
    }

    public Config enableParameterTamperingProtection(String salt) {
        if (Utils.isEmptyOrNull(salt)) {
            if (this.configLog != null) {
                this.configLog.e("[ConfigCore] Salt cannot be empty in enableParameterTamperingProtection");
            }
        } else {
            this.salt = salt;
        }
        return this;
    }

    public Config setLoggingTag(String loggingTag) {
        return this;
    }

    public Config setLoggingLevel(LoggingLevel loggingLevel) {
        if (loggingLevel == null) {
            if (this.configLog != null) {
                this.configLog.e("[ConfigCore] Logging level cannot be null");
            }
        } else {
            this.loggingLevel = loggingLevel;
        }
        return this;
    }

    public Config enableTestMode() {
        return this;
    }

    public Config disableTestMode() {
        return this;
    }

    public Config setSendUpdateEachSeconds(int sendUpdateEachSeconds) {
        if (sendUpdateEachSeconds < 0) {
            if (this.configLog != null) {
                this.configLog.e("[ConfigCore] sendUpdateEachSeconds cannot be negative");
            }
        } else {
            this.sendUpdateEachSeconds = sendUpdateEachSeconds;
        }
        return this;
    }

    public Config setEventsBufferSize(int eventsBufferSize) {
        if (eventsBufferSize < 0) {
            if (this.configLog != null) {
                this.configLog.e("[ConfigCore] eventsBufferSize cannot be negative");
            }
        } else {
            this.eventsBufferSize = eventsBufferSize;
        }
        return this;
    }

    public Config disableUpdateRequests() {
        this.sendUpdateEachSeconds = 0;
        return this;
    }

    public Config setSdkName(String sdkName) {
        return this;
    }

    public Config setSdkVersion(String sdkVersion) {
        return this;
    }

    public Config setApplicationName(String name) {
        return this;
    }

    public Config setApplicationVersion(String version) {
        if (Utils.isEmptyOrNull(version)) {
            if (this.configLog != null) {
                this.configLog.e("[ConfigCore] version cannot be empty");
            }
        } else {
            this.applicationVersion = version;
        }
        return this;
    }

    public Config setNetworkConnectTimeout(int seconds) {
        if (seconds <= 0 || seconds > 300) {
            if (this.configLog != null) {
                this.configLog.e("[ConfigCore] Connection timeout must be between 0 and 300");
            }
        } else {
            this.networkConnectionTimeout = seconds;
        }
        return this;
    }

    public Config setNetworkReadTimeout(int seconds) {
        if (seconds <= 0 || seconds > 300) {
            if (this.configLog != null) {
                this.configLog.e("[ConfigCore] Read timeout must be between 0 and 300");
            }
        } else {
            this.networkReadTimeout = seconds;
        }
        return this;
    }

    public Config setNetworkRequestCooldown(int milliseconds) {
        if (milliseconds < 0 || milliseconds > 30000) {
            if (this.configLog != null) {
                this.configLog.e("[ConfigCore] Request cooldown must be between 0 and 30000");
            }
        } else {
            this.networkRequestCooldown = milliseconds;
        }
        return this;
    }

    public Config setNetworkImportantRequestCooldown(int milliseconds) {
        if (milliseconds < 0 || milliseconds > 30) {
            if (this.configLog != null) {
                this.configLog.e("[ConfigCore] Important request cooldown must be between 0 and 30");
            }
        } else {
            this.networkImportantRequestCooldown = milliseconds;
        }
        return this;
    }

    public Config addPublicKeyPin(String pemEncodedPublicKey) {
        if (Utils.isEmptyOrNull(pemEncodedPublicKey)) {
            if (this.configLog != null) {
                this.configLog.e("[ConfigCore] pemEncodedPublicKey cannot be empty");
            }
        } else {
            if (this.publicKeyPins == null) {
                this.publicKeyPins = new HashSet<String>();
            }
            this.publicKeyPins.add(pemEncodedPublicKey);
        }
        return this;
    }

    public Config addCertificatePin(String pemEncodedCertificate) {
        if (Utils.isEmptyOrNull(pemEncodedCertificate)) {
            if (this.configLog != null) {
                this.configLog.e("[ConfigCore] pemEncodedCertificate cannot be empty");
            }
        } else {
            if (this.certificatePins == null) {
                this.certificatePins = new HashSet<String>();
            }
            this.certificatePins.add(pemEncodedCertificate);
        }
        return this;
    }

    public Config setCrashReportingANRCheckingPeriod(int periodInSeconds) {
        return this;
    }

    public Config disableANRCrashReporting() {
        return this;
    }

    public Config setCrashProcessorClass(Class<? extends CrashProcessor> crashProcessorClass) {
        if (crashProcessorClass == null) {
            if (this.configLog != null) {
                this.configLog.e("[ConfigCore] crashProcessorClass cannot be null");
            }
        } else {
            this.crashProcessorClass = crashProcessorClass.getName();
        }
        return this;
    }

    protected Config overrideModule(Integer feature, Class<? extends Module> cls) {
        return this;
    }

    public Set<Feature> getFeatures() {
        HashSet<Feature> ftrs = new HashSet<Feature>();
        for (Feature f : Feature.values()) {
            if ((f.index & this.features) <= 0) continue;
            ftrs.add(f);
        }
        return ftrs;
    }

    public int getFeaturesMap() {
        return this.features;
    }

    public boolean isFeatureEnabled(Feature feature) {
        return (this.features & feature.index) > 0;
    }

    public Class<? extends Module> getModuleOverride(Feature feature) {
        return null;
    }

    public Config setRequiresConsent(boolean requiresConsent) {
        this.requiresConsent = requiresConsent;
        return this;
    }

    public URL getServerURL() {
        return this.serverURL;
    }

    public String getServerAppKey() {
        return this.serverAppKey;
    }

    public int getDeviceIdStrategy() {
        return this.deviceIdStrategy;
    }

    public boolean isDeviceIdFallbackAllowed() {
        return true;
    }

    public String getCustomDeviceId() {
        return this.customDeviceId;
    }

    public boolean isUsePOST() {
        return this.usePOST;
    }

    public boolean isBackendModeEnabled() {
        return this.enableBackendMode;
    }

    public String getParameterTamperingProtectionSalt() {
        return this.salt;
    }

    public String getSdkName() {
        return this.sdkName;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public boolean isFeatureEnabled(int feature) {
        return (this.features & feature) > 0;
    }

    public String getApplicationName() {
        return "";
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public String getLoggingTag() {
        return "Countly";
    }

    public LoggingLevel getLoggingLevel() {
        return this.loggingLevel;
    }

    public LogCallback getLogListener() {
        return this.logListener;
    }

    public boolean isTestModeEnabled() {
        return false;
    }

    public int getSendUpdateEachSeconds() {
        return this.sendUpdateEachSeconds;
    }

    public int getEventsBufferSize() {
        return this.eventsBufferSize;
    }

    public int getNetworkConnectionTimeout() {
        return this.networkConnectionTimeout;
    }

    public int getNetworkReadTimeout() {
        return this.networkReadTimeout;
    }

    public int getNetworkRequestCooldown() {
        return this.networkRequestCooldown;
    }

    public int getNetworkImportantRequestCooldown() {
        return this.networkImportantRequestCooldown;
    }

    public Set<String> getPublicKeyPins() {
        return this.publicKeyPins;
    }

    public Set<String> getCertificatePins() {
        return this.certificatePins;
    }

    public int getCrashReportingANRCheckingPeriod() {
        return 5;
    }

    public String getCrashProcessorClass() {
        return this.crashProcessorClass;
    }

    public Class<? extends Module> getModuleOverride(int feature) {
        return null;
    }

    public boolean requiresConsent() {
        return this.requiresConsent;
    }

    public Config setMetricOverride(Map<String, String> metricOverride) {
        this.metricOverride.putAll(metricOverride);
        return this;
    }

    public static final class DID
    implements Byteable {
        public static final int STRATEGY_UUID = 0;
        public static final int STRATEGY_CUSTOM = 10;
        public static final int REALM_DID = 0;
        public final int realm;
        public final int strategy;
        public final String id;

        public DID(int realm, int strategy, String id) {
            this.realm = realm;
            this.strategy = strategy;
            this.id = id;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof DID)) {
                return false;
            }
            DID did = (DID)obj;
            return did.realm == this.realm && did.strategy == this.strategy && (did.id == null ? this.id == null : did.id.equals(this.id));
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            return "DID " + this.id + " (" + this.realm + ", " + this.strategy + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] store(Log L) {
            ByteArrayOutputStream bytes = null;
            ObjectOutputStream stream = null;
            try {
                bytes = new ByteArrayOutputStream();
                stream = new ObjectOutputStream(bytes);
                stream.writeInt(this.realm);
                stream.writeInt(this.strategy);
                stream.writeObject(this.id);
                stream.close();
                byte[] byArray = bytes.toByteArray();
                return byArray;
            }
            catch (IOException e) {
                if (L != null) {
                    L.e("[ConfigCore] Cannot serialize config" + e.toString());
                }
            }
            finally {
                block22: {
                    block21: {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException e) {
                                if (L == null) break block21;
                                L.e("[ConfigCore] Cannot happen" + e.toString());
                            }
                        }
                    }
                    if (bytes != null) {
                        try {
                            bytes.close();
                        }
                        catch (IOException e) {
                            if (L == null) break block22;
                            L.e("[ConfigCore] Cannot happen" + e.toString());
                        }
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean restore(byte[] data, Log L) {
            ByteArrayInputStream bytes = null;
            ObjectInputStream stream = null;
            try {
                bytes = new ByteArrayInputStream(data);
                stream = new ObjectInputStream(bytes);
                Utils.reflectiveSetField(this, "realm", (Object)stream.readInt(), L);
                Utils.reflectiveSetField(this, "strategy", (Object)stream.readInt(), L);
                Utils.reflectiveSetField(this, "id", stream.readObject(), L);
                boolean bl = true;
                return bl;
            }
            catch (IOException | ClassNotFoundException e) {
                if (L != null) {
                    L.e("[ConfigCore] Cannot deserialize config" + e.toString());
                }
            }
            finally {
                block22: {
                    block21: {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException e) {
                                if (L == null) break block21;
                                L.e("[ConfigCore] Cannot happen" + e.toString());
                            }
                        }
                    }
                    if (bytes != null) {
                        try {
                            bytes.close();
                        }
                        catch (IOException e) {
                            if (L == null) break block22;
                            L.e("[ConfigCore] Cannot happen" + e.toString());
                        }
                    }
                }
            }
            return false;
        }
    }

    public static enum Feature {
        Events(CoreFeature.Events.getIndex()),
        Sessions(CoreFeature.Sessions.getIndex()),
        Views(CoreFeature.Views.getIndex()),
        CrashReporting(CoreFeature.CrashReporting.getIndex()),
        Location(CoreFeature.Location.getIndex()),
        UserProfiles(CoreFeature.UserProfiles.getIndex());

        private final int index;

        private Feature(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static Feature byIndex(int index) {
            if (index == Feature.Events.index) {
                return Events;
            }
            if (index == Feature.Sessions.index) {
                return Sessions;
            }
            if (index == Feature.Views.index) {
                return Views;
            }
            if (index == Feature.CrashReporting.index) {
                return CrashReporting;
            }
            if (index == Feature.Location.index) {
                return Location;
            }
            if (index == Feature.UserProfiles.index) {
                return UserProfiles;
            }
            return null;
        }
    }

    public static enum DeviceIdStrategy {
        UUID(0),
        CUSTOM_ID(10);

        private final int index;

        private DeviceIdStrategy(int level) {
            this.index = level;
        }

        public int getIndex() {
            return this.index;
        }

        public static DeviceIdStrategy fromIndex(int index) {
            if (index == DeviceIdStrategy.UUID.index) {
                return UUID;
            }
            if (index == DeviceIdStrategy.CUSTOM_ID.index) {
                return CUSTOM_ID;
            }
            return null;
        }
    }

    public static enum LoggingLevel {
        VERBOSE(0),
        DEBUG(1),
        INFO(2),
        WARN(3),
        ERROR(4),
        OFF(5);

        private final int level;

        private LoggingLevel(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }

        public boolean prints(LoggingLevel l) {
            return this.level <= l.level;
        }
    }
}

