/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java;

import java.io.File;
import java.util.Map;
import ly.count.sdk.java.Config;
import ly.count.sdk.java.Event;
import ly.count.sdk.java.Session;
import ly.count.sdk.java.Usage;
import ly.count.sdk.java.User;
import ly.count.sdk.java.View;
import ly.count.sdk.java.internal.CtxCore;
import ly.count.sdk.java.internal.Device;
import ly.count.sdk.java.internal.InternalConfig;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.ModuleBackendMode;
import ly.count.sdk.java.internal.SDKCore;

public class Countly
implements Usage {
    public static Device device = Device.dev;
    protected static Countly cly;
    protected SDKCore sdk;
    protected CtxCore ctx;
    protected Log L;

    protected Countly(SDKCore sdk, CtxCore ctx, Log logger) {
        cly = this;
        this.L = logger;
        this.sdk = sdk;
        this.ctx = ctx;
    }

    public static void init(File directory, Config config) {
        if (config == null) {
            System.out.println("[ERROR][Countly] Config cannot be null");
            return;
        }
        InternalConfig internalConfig = new InternalConfig(config);
        Log L = new Log(internalConfig.loggingLevel, internalConfig.logListener);
        if (directory == null) {
            L.e("[Countly] File cannot be null");
            return;
        }
        if (!directory.isDirectory()) {
            L.e("[Countly] File must be a directory");
            return;
        }
        if (!directory.exists()) {
            L.e("[Countly] File must exist");
            return;
        }
        if (cly != null) {
            L.e("[Countly] Countly shouldn't be initialized twice. Please either use Countly.isInitialized() to check status or call Countly.stop() before second Countly.init().");
            Countly.stop(false);
        }
        if (internalConfig.enableBackendMode) {
            internalConfig.sdkName = "java-native-backend";
        }
        if (internalConfig.requestQueueMaxSize < 1) {
            L.e("[Countly] init: Request queue max size can not be less than 1.");
            internalConfig.requestQueueMaxSize = 1;
        }
        device.setMetricOverride(internalConfig.getMetricOverride());
        if (internalConfig.getApplicationVersion() != null) {
            device.setAppVersion(internalConfig.getApplicationVersion());
        }
        SDKCore sdk = new SDKCore();
        sdk.init(new CtxCore(sdk, internalConfig, L, directory), L);
        cly = new Countly(sdk, new CtxCore(sdk, sdk.config(), L, directory), L);
    }

    public static void stop(boolean clearData) {
        if (cly != null) {
            if (Countly.cly.L != null) {
                Countly.cly.L.e("[Countly] Stopping SDK");
            }
            Countly.cly.sdk.stop(Countly.cly.ctx, clearData);
            cly = null;
        }
    }

    public static boolean isInitialized() {
        return cly != null;
    }

    public static boolean isTracking(Config.Feature feature) {
        return Countly.isInitialized() && Countly.cly.sdk.isTracking(feature.getIndex());
    }

    public static Session session() {
        if (!Countly.isInitialized()) {
            if (cly != null && Countly.cly.L != null) {
                Countly.cly.L.e("[Countly] SDK is not initialized yet.");
            }
            return null;
        }
        return Countly.session(Countly.cly.ctx);
    }

    public static ModuleBackendMode.BackendMode backendMode() {
        if (!Countly.isInitialized()) {
            if (cly != null && Countly.cly.L != null) {
                Countly.cly.L.e("[Countly] SDK is not initialized yet.");
            }
            return null;
        }
        ModuleBackendMode mbm = Countly.cly.sdk.module(ModuleBackendMode.class);
        if (Countly.cly.ctx.getConfig().enableBackendMode && mbm != null) {
            return new ModuleBackendMode.BackendMode(mbm);
        }
        if (cly != null && Countly.cly.L != null) {
            Countly.cly.L.w("[Countly] BackendMode was not enabled, returning dummy module");
        }
        ModuleBackendMode emptyMbm = new ModuleBackendMode();
        emptyMbm.disableModule();
        return new ModuleBackendMode.BackendMode(emptyMbm);
    }

    public static Session getSession() {
        if (!Countly.isInitialized()) {
            if (cly != null && Countly.cly.L != null) {
                Countly.cly.L.e("[Countly] SDK is not initialized yet.");
            }
            return null;
        }
        return Countly.session(Countly.cly.ctx);
    }

    public static Usage api() {
        return cly;
    }

    @Override
    public Usage login(String id) {
        if (Countly.cly.L != null) {
            this.L.d("[Countly] login");
        }
        this.sdk.login(this.ctx, id);
        return this;
    }

    @Override
    public Usage logout() {
        if (Countly.cly.L != null) {
            this.L.d("[Countly] logout");
        }
        this.sdk.logout(this.ctx);
        return this;
    }

    @Override
    public String getDeviceId() {
        return this.ctx.getConfig().getDeviceId().id;
    }

    @Override
    public Usage resetDeviceId(String id) {
        if (Countly.cly.L != null) {
            this.L.d("[Countly] resetDeviceId: id = " + id);
        }
        this.sdk.changeDeviceIdWithoutMerge(this.ctx, id);
        return this;
    }

    @Override
    public Usage changeDeviceIdWithMerge(String id) {
        if (Countly.cly.L != null) {
            this.L.d("[Countly] changeDeviceIdWithoutMerge: id = " + id);
        }
        this.sdk.changeDeviceIdWithMerge(this.ctx, id);
        return this;
    }

    @Override
    public Usage changeDeviceIdWithoutMerge(String id) {
        if (Countly.cly.L != null) {
            this.L.d("[Countly] changeDeviceIdWithoutMerge: id = " + id);
        }
        this.sdk.changeDeviceIdWithoutMerge(this.ctx, id);
        return this;
    }

    public static void onConsent(Config.Feature ... features) {
        if (!Countly.isInitialized()) {
            if (cly != null && Countly.cly.L != null) {
                Countly.cly.L.e("[Countly] SDK is not initialized yet.");
            }
        } else {
            if (cly != null && Countly.cly.L != null) {
                Countly.cly.L.e("[Countly] onConsent: features = " + features);
            }
            int ftrs = 0;
            for (Config.Feature f : features) {
                ftrs |= f.getIndex();
            }
            Countly.cly.sdk.onConsent(Countly.cly.ctx, ftrs);
        }
    }

    public static void onConsentRemoval(Config.Feature ... features) {
        if (cly != null && Countly.cly.L != null) {
            Countly.cly.L.e("[Countly] onConsentRemoval: features = " + features);
        }
        if (!Countly.isInitialized()) {
            if (cly != null && Countly.cly.L != null) {
                Countly.cly.L.e("[Countly] onConsentRemoval: SDK is not initialized yet.");
            }
        } else {
            int ftrs = 0;
            for (Config.Feature f : features) {
                ftrs |= f.getIndex();
            }
            Countly.cly.sdk.onConsentRemoval(Countly.cly.ctx, ftrs);
        }
    }

    protected static Session session(CtxCore ctx) {
        return Countly.cly.sdk.session(ctx, null);
    }

    @Override
    public Event event(String key) {
        this.L.d("[Cly] event: key = " + key);
        return this.sdk.session(this.ctx, null).event(key);
    }

    @Override
    public Event timedEvent(String key) {
        this.L.d("[Cly] timedEvent: key = " + key);
        return this.sdk.session(this.ctx, null).timedEvent(key);
    }

    @Override
    public User user() {
        this.L.d("[Cly] user");
        return this.sdk.session(this.ctx, null).user();
    }

    @Override
    public Usage addParam(String key, Object value) {
        this.L.d("[Cly] addParam: key = " + key + " value = " + value);
        return this.sdk.session(this.ctx, null).addParam(key, value);
    }

    @Override
    public Usage addCrashReport(Throwable t, boolean fatal) {
        this.L.d("[Cly] addCrashReport: t = " + t + " fatal = " + fatal);
        return this.sdk.session(this.ctx, null).addCrashReport(t, fatal);
    }

    @Override
    public Usage addCrashReport(Throwable t, boolean fatal, String name, Map<String, String> segments, String ... logs) {
        this.L.d("[Cly] addCrashReport: t = " + t + " fatal = " + fatal + " name = " + name + " segments = " + segments + " logs = " + logs);
        return this.sdk.session(this.ctx, null).addCrashReport(t, fatal, name, segments, logs);
    }

    @Override
    public Usage addLocation(double latitude, double longitude) {
        this.L.d("[Cly] addLocation: latitude = " + latitude + " longitude = " + longitude);
        return this.sdk.session(this.ctx, null).addLocation(latitude, longitude);
    }

    @Override
    public View view(String name, boolean start) {
        this.L.d("[Cly] view: name = " + name + " start = " + start);
        return this.sdk.session(this.ctx, null).view(name, start);
    }

    @Override
    public View view(String name) {
        this.L.d("[Cly] view: name = " + name);
        return this.sdk.session(this.ctx, null).view(name);
    }
}

