/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ly.count.sdk.java.Crash;
import ly.count.sdk.java.internal.CtxCore;
import ly.count.sdk.java.internal.Device;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.Storable;
import ly.count.sdk.java.internal.Utils;
import org.json.JSONException;
import org.json.JSONObject;

public class CrashImpl
implements Crash,
Storable {
    private Log L = null;
    private final Long id;
    private final JSONObject data;
    private Throwable throwable;
    private Map<Thread, StackTraceElement[]> traces;

    protected CrashImpl(Log logger) {
        this(Device.dev.uniformTimestamp(), logger);
    }

    protected CrashImpl(Long id, Log logger) {
        this.L = logger;
        this.id = id;
        this.data = new JSONObject();
        this.add("_nonfatal", true);
    }

    @Override
    public CrashImpl addThrowable(Throwable throwable) {
        this.throwable = throwable;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.throwable.printStackTrace(pw);
        return this.add("_error", sw.toString());
    }

    @Override
    public CrashImpl addException(Exception e) {
        return this.addThrowable(e);
    }

    @Override
    public CrashImpl addTraces(Thread main, Map<Thread, StackTraceElement[]> traces) {
        if (traces == null) {
            this.L.e("[CrashImpl traces cannot be null");
            return this;
        }
        this.traces = traces;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (main != null && traces.containsKey(main)) {
            pw.println("Thread [main]:");
            this.printTraces(pw, null, traces.get(main));
            pw.append("\n\n");
        }
        for (Thread thread : traces.keySet()) {
            if (thread == main) continue;
            this.printTraces(pw, thread, traces.get(thread));
            pw.append("\n\n");
        }
        return this.add("_type", "anr").add("_error", sw.toString());
    }

    private void printTraces(PrintWriter pw, Thread thread, StackTraceElement[] traces) {
        if (thread != null) {
            pw.append("Thread [").append(thread.getName()).append("]:\n");
        }
        for (StackTraceElement el : traces) {
            pw.append("\tat ").append(el == null ? "<<Unknown>>" : el.toString()).append("\n");
        }
    }

    @Override
    public CrashImpl setFatal(boolean fatal) {
        return this.add("_nonfatal", !fatal);
    }

    @Override
    public CrashImpl setName(String name) {
        return this.add("_name", name);
    }

    @Override
    public CrashImpl setSegments(Map<String, String> segments) {
        if (segments != null && segments.size() > 0) {
            return this.add("_custom", new JSONObject(segments));
        }
        return this;
    }

    @Override
    public CrashImpl setLogs(String[] logs) {
        if (logs != null && logs.length > 0) {
            return this.add("_logs", Utils.join(Arrays.asList(logs), "\n"));
        }
        return this;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public Map<Thread, StackTraceElement[]> getTraces() {
        return this.traces;
    }

    @Override
    public boolean isFatal() {
        try {
            return !this.data.has("_nonfatal") || !this.data.getBoolean("_nonfatal");
        }
        catch (JSONException e) {
            return true;
        }
    }

    @Override
    public String getName() {
        try {
            return this.data.has("_name") ? this.data.getString("_name") : null;
        }
        catch (JSONException e) {
            return null;
        }
    }

    @Override
    public Map<String, String> getSegments() {
        try {
            if (!this.data.has("_custom")) {
                return null;
            }
            JSONObject object = this.data.getJSONObject("_custom");
            HashMap<String, String> map = new HashMap<String, String>();
            Iterator iterator = object.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                map.put(key, object.getString(key));
            }
            return map;
        }
        catch (JSONException e) {
            return null;
        }
    }

    @Override
    public List<String> getLogs() {
        try {
            String logs = this.data.getString("_logs");
            return Utils.isEmptyOrNull(logs) ? null : Arrays.asList(logs.split("\n"));
        }
        catch (JSONException e) {
            return null;
        }
    }

    protected CrashImpl add(String key, Object value) {
        if (Utils.isNotEmpty(key) && value != null) {
            try {
                this.data.put(key, value);
            }
            catch (JSONException e) {
                this.L.e("[CrashImpl Couldn't add " + key + " to a crash" + (Object)((Object)e));
            }
        }
        return this;
    }

    @Override
    public byte[] store(Log L) {
        try {
            return this.data.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            if (L != null) {
                L.e("[CrashImpl UTF is not supported" + e);
            }
            return null;
        }
    }

    @Override
    public boolean restore(byte[] data, Log L) {
        try {
            block6: {
                String json = new String(data, "UTF-8");
                try {
                    JSONObject obj = new JSONObject(json);
                    Iterator iterator = obj.keys();
                    while (iterator.hasNext()) {
                        String k = (String)iterator.next();
                        this.data.put(k, obj.get(k));
                    }
                }
                catch (JSONException e) {
                    if (L == null) break block6;
                    L.e("[CrashImpl Couldn't decode crash data successfully" + (Object)((Object)e));
                }
            }
            return true;
        }
        catch (UnsupportedEncodingException e) {
            if (L != null) {
                L.e("[CrashImpl Cannot deserialize crash" + e);
            }
            return false;
        }
    }

    @Override
    public Long storageId() {
        return this.id;
    }

    @Override
    public String storagePrefix() {
        return CrashImpl.getStoragePrefix();
    }

    public static String getStoragePrefix() {
        return "crash";
    }

    public CrashImpl putMetrics(CtxCore ctx, Long runningTime) {
        this.add("_device", Device.dev.getDevice());
        this.add("_os", Device.dev.getOS());
        this.add("_os_version", Device.dev.getOSVersion());
        this.add("_resolution", Device.dev.getResolution());
        this.add("_app_version", Device.dev.getAppVersion());
        this.add("_manufacture", Device.dev.getManufacturer());
        this.add("_cpu", Device.dev.getCpu());
        this.add("_opengl", Device.dev.getOpenGL());
        this.add("_ram_current", Device.dev.getRAMAvailable());
        this.add("_ram_total", Device.dev.getRAMTotal());
        this.add("_disk_current", Device.dev.getDiskAvailable());
        this.add("_disk_total", Device.dev.getDiskTotal());
        this.add("_bat", Device.dev.getBatteryLevel());
        this.add("_run", runningTime);
        this.add("_orientation", Device.dev.getOrientation());
        this.add("_online", Device.dev.isOnline());
        this.add("_muted", Device.dev.isMuted());
        return this;
    }

    public String getJSON() {
        return this.data.toString();
    }

    public JSONObject getData() {
        return this.data;
    }

    public String toString() {
        return this.data.toString();
    }
}

